/*
 * Decompiled with CFR 0.152.
 */
package org.fugerit.java.daogen.base.gen;

import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Iterator;
import lombok.Generated;
import org.fugerit.java.core.cfg.ConfigException;
import org.fugerit.java.core.cfg.ConfigRuntimeException;
import org.fugerit.java.core.javagen.GeneratorNameHelper;
import org.fugerit.java.core.lang.helpers.BooleanUtils;
import org.fugerit.java.daogen.base.config.DaogenCatalogConfig;
import org.fugerit.java.daogen.base.config.DaogenCatalogConstants;
import org.fugerit.java.daogen.base.config.DaogenCatalogEntity;
import org.fugerit.java.daogen.base.config.DaogenCatalogField;
import org.fugerit.java.daogen.base.config.DaogenClassConfigHelper;
import org.fugerit.java.daogen.base.gen.DaogenBasicGenerator;
import org.fugerit.java.daogen.base.gen.util.FacadeGeneratorUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RSEGenerator
extends DaogenBasicGenerator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RSEGenerator.class);
    public static final String KEY = "RSEGenerator";

    public String getKey() {
        return KEY;
    }

    @Override
    public boolean isGenerate(DaogenCatalogConfig daogenConfig, DaogenCatalogEntity entity) {
        return FacadeGeneratorUtils.isFacadeGenerate(entity);
    }

    @Override
    public void init(DaogenCatalogConfig daogenConfig, DaogenCatalogEntity entity) throws ConfigException {
        super.init(daogenConfig.getGeneralProp("src-main-java"), RSEGenerator.fullObjectName(daogenConfig.getGeneralProp("package-rse"), DaogenCatalogConstants.rseName(entity)), "class", daogenConfig, entity);
        this.setClassRSEHelper(DaogenClassConfigHelper.addImport(daogenConfig, "dao.rsehelper", this.getImportList()));
        this.getImportList().add(this.getDaogenConfig().getGeneralProp("package-model") + "." + this.getEntityModelName());
        this.getImportList().add(this.getDaogenConfig().getGeneralProp("package-helper") + "." + this.getEntityHelperName());
        this.getImportList().add("java.sql.ResultSet");
        this.getImportList().add("java.sql.SQLException");
        this.setExtendsClass(this.getClassRSEHelper() + "<" + this.getEntityModelName() + ">");
    }

    @Override
    public void generateDaogenBody() throws IOException {
        this.addSerialVerUID();
        String disableSingleton = this.getDaogenConfig().getGeneralProp("disable-singleton", "disabled");
        log.info("{} -> {}", (Object)"disable-singleton", (Object)disableSingleton);
        if (!"enabled".equalsIgnoreCase(disableSingleton)) {
            this.getWriter().println("\tpublic static final " + this.getEntityRSEName() + " DEFAULT = new " + this.getEntityRSEName() + "();");
            this.getWriter().println();
        }
        this.getWriter().println("\t@Override");
        this.getWriter().println("\tpublic " + this.getEntityModelName() + " extractNext( ResultSet rs ) throws SQLException { ");
        this.getWriter().println("\t\t" + this.getEntityHelperName() + " current = new " + this.getEntityHelperName() + "();");
        String blobHandlerType = this.getDaogenConfig().getTypeMapper().getTypeMapConfig().getProperty("model_java.sql.Blob");
        String clobHandlerType = this.getDaogenConfig().getTypeMapper().getTypeMapConfig().getProperty("model_java.sql.Clob");
        Iterator iterator = this.getCurrentEntity().iterator();
        while (iterator.hasNext()) {
            DaogenCatalogField field = (DaogenCatalogField)((Object)iterator.next());
            this.handleField(field, blobHandlerType, clobHandlerType);
        }
        this.getWriter().println("\t\treturn current;");
        this.getWriter().println("\t} ");
    }

    private void handleField(DaogenCatalogField field, String blobHandlerType, String clobHandlerType) {
        String columnName = field.getId();
        String columnType = this.getDaogenConfig().getTypeMapper().mapForModel(field);
        String javaSuffix = GeneratorNameHelper.toClassName((String)field.getId());
        String extratMethod = null;
        String indent = "";
        boolean unsafe = BooleanUtils.isTrue((String)field.getUnsafe());
        if (unsafe) {
            this.getWriter().println("\t\t// unsafe field (error will be only printed)");
            this.getWriter().println("\t\ttry { ");
            indent = "\t";
        }
        boolean tryCatch = false;
        if (columnType.equalsIgnoreCase(String.class.getName())) {
            extratMethod = "rs.getString( \"" + columnName + "\" ) ";
        } else if (columnType.equalsIgnoreCase(BigDecimal.class.getName())) {
            extratMethod = "rs.getBigDecimal( \"" + columnName + "\" ) ";
        } else if (columnType.equalsIgnoreCase(Integer.class.getName())) {
            extratMethod = "rs.getInt( \"" + columnName + "\" ) ";
        } else if (columnType.equalsIgnoreCase(Date.class.getName())) {
            extratMethod = "rs.getDate( \"" + columnName + "\" ) ";
        } else if (columnType.equalsIgnoreCase(java.util.Date.class.getName())) {
            extratMethod = "rs.getTimestamp( \"" + columnName + "\" ) ";
        } else if (columnType.equalsIgnoreCase(Timestamp.class.getName())) {
            extratMethod = "rs.getTimestamp( \"" + columnName + "\" ) ";
        } else if (columnType.equalsIgnoreCase(LocalDate.class.getName())) {
            extratMethod = "org.fugerit.java.core.db.daogen.SQLTypeConverter.utilDateToLocalDate( rs.getDate( \"" + columnName + "\" ) ) ";
        } else if (columnType.equalsIgnoreCase(LocalTime.class.getName())) {
            extratMethod = "org.fugerit.java.core.db.daogen.SQLTypeConverter.utilDateToLocalTime( rs.getTime( \"" + columnName + "\" ) ) ";
        } else if (columnType.equalsIgnoreCase(LocalDateTime.class.getName())) {
            extratMethod = "org.fugerit.java.core.db.daogen.SQLTypeConverter.utilDateToLocalDateTime( rs.getTimestamp( \"" + columnName + "\" ) ) ";
        } else if (columnType.equalsIgnoreCase(blobHandlerType)) {
            extratMethod = blobHandlerType + ".newHandlerPreload( rs.getBlob( \"" + columnName + "\" ) ) ";
            tryCatch = true;
        } else if (columnType.equalsIgnoreCase(clobHandlerType)) {
            extratMethod = clobHandlerType + ".newHandlerPreload( rs.getClob( \"" + columnName + "\" ) ) ";
            tryCatch = true;
        } else {
            throw new ConfigRuntimeException("Type : " + columnType + " not handled yet!");
        }
        this.handleEnd(tryCatch, indent, javaSuffix, columnName, extratMethod, unsafe);
    }

    private void handleEnd(boolean tryCatch, String indent, String javaSuffix, String columnName, String extratMethod, boolean unsafe) {
        if (tryCatch) {
            this.getWriter().println(indent + "\t\t" + "try { ");
            this.getWriter().println(indent + "\t\t\t" + "current.set" + javaSuffix + "( " + extratMethod + " );");
            this.getWriter().println(indent + "\t\t" + "} catch (Exception e) {");
            this.getWriter().println(indent + "\t\t\t" + "throw new SQLException( \"Errore estrazione campo : " + columnName + "\", e );");
            this.getWriter().println(indent + "\t\t" + "}");
        } else {
            this.getWriter().println(indent + "\t\t" + "current.set" + javaSuffix + "( " + extratMethod + " );");
        }
        if (unsafe) {
            this.getWriter().println("\t\t} catch (Exception e1) {");
            this.getWriter().println("\t\t\tlogger.warn( \"Exception handling field '{}' -> {}\", \"" + columnName + "\", e1 );");
            this.getWriter().println("\t\t}");
        }
    }
}

