/*
 * Decompiled with CFR 0.152.
 */
package org.fugerit.java.daogen.base.gen;

import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Iterator;
import org.fugerit.java.core.cfg.ConfigException;
import org.fugerit.java.core.cfg.ConfigRuntimeException;
import org.fugerit.java.core.javagen.GeneratorNameHelper;
import org.fugerit.java.core.lang.helpers.reflect.MethodHelper;
import org.fugerit.java.daogen.base.config.DaogenCatalogConfig;
import org.fugerit.java.daogen.base.config.DaogenCatalogConstants;
import org.fugerit.java.daogen.base.config.DaogenCatalogEntity;
import org.fugerit.java.daogen.base.config.DaogenCatalogField;
import org.fugerit.java.daogen.base.config.DaogenClassConfigHelper;
import org.fugerit.java.daogen.base.gen.DaogenBasicGenerator;
import org.fugerit.java.daogen.base.gen.util.PropertyUtils;
import org.fugerit.java.daogen.base.gen.util.TypeUtils;

public class StructGenerator
extends DaogenBasicGenerator {
    public static final String KEY = "StructGenerator";

    public String getKey() {
        return KEY;
    }

    @Override
    public void init(DaogenCatalogConfig daogenConfig, DaogenCatalogEntity entity) throws ConfigException {
        super.init(daogenConfig.getGeneralProp("src-main-java"), StructGenerator.fullObjectName(daogenConfig.getGeneralProp("package-struct"), DaogenCatalogConstants.structName(daogenConfig, entity)), "class", daogenConfig, entity);
        this.setClassStructMapper(DaogenClassConfigHelper.addImport(daogenConfig, "dao.structmapper", this.getImportList()));
        this.getImportList().add(this.getDaogenConfig().getGeneralProp("package-model") + "." + this.getEntityModelName());
        this.getImportList().add(this.getDaogenConfig().getGeneralProp("package-helper") + "." + this.getEntityHelperName());
        this.getImportList().add(this.getDaogenConfig().getGeneralProp("package-helper") + "." + this.getEntityWrapperName());
        this.getImportList().add("java.util.Map");
        this.getImportList().add("java.util.HashMap");
        this.getImportList().add("java.sql.SQLData");
        this.getImportList().add("java.sql.SQLInput");
        this.getImportList().add("java.sql.SQLOutput");
        this.getImportList().add("java.sql.SQLException");
        this.setImplementsInterface("SQLData, " + this.getClassStructMapper());
        this.setExtendsClass(this.getEntityWrapperName());
    }

    private void generateDaogenBodyStart() {
        this.getWriter().println("\tpublic " + this.getEntityStructName() + "( " + this.getEntityModelName() + " wrapped ) {");
        this.getWriter().println("\t\tsuper( wrapped );");
        this.getWriter().println("\t}");
        this.getWriter().println();
        this.getWriter().println("\tpublic " + this.getEntityStructName() + "() {");
        this.getWriter().println("\t\tthis( new " + this.getEntityHelperName() + "() );");
        this.getWriter().println("\t}");
        this.getWriter().println();
        this.getWriter().println("\tpublic static final String SQL_TYPE_NAME = \"" + this.getSQLStructName().toUpperCase() + "\";");
        this.getWriter().println();
        this.getWriter().println("\tpublic static final " + this.getEntityStructName() + " MAPPER = new " + this.getEntityStructName() + "();");
        this.getWriter().println();
        this.getWriter().println("\t@Override");
        this.getWriter().println("\tpublic Map<String, Class<?>> newTypeMapper() throws SQLException {");
        this.getWriter().println("\t\tMap<String, Class<?>> map = new HashMap<>();");
        this.getWriter().println("\t\tmap.put( SQL_TYPE_NAME, " + this.getEntityStructName() + ".class );");
        this.getWriter().println("\t\treturn map;");
        this.getWriter().println("\t}");
        this.getWriter().println();
        this.getWriter().println("\t@Override");
        this.getWriter().println("\tpublic String getSQLTypeName() throws SQLException {");
        this.getWriter().println("\t\treturn SQL_TYPE_NAME;");
        this.getWriter().println("\t}");
        this.getWriter().println();
        this.getWriter().println("\tpublic static " + this.getEntityStructName() + " wrap( " + this.getEntityModelName() + " model ) {");
        this.getWriter().println("\t\t" + this.getEntityStructName() + " res = null;");
        this.getWriter().println("\t\tif ( model instanceof " + this.getEntityStructName() + " ) {");
        this.getWriter().println("\t\t\tres = (" + this.getEntityStructName() + ") model;");
        this.getWriter().println("\t\t} else { ");
        this.getWriter().println("\t\t\tres = new " + this.getEntityStructName() + "( model );");
        this.getWriter().println("\t\t}");
        this.getWriter().println("\t\treturn res;");
        this.getWriter().println("\t}");
        this.getWriter().println();
    }

    private void generateDaogenBodyLobField(String blobHandlerType, String clobHandlerType, StringBuilder line) {
        boolean isFirst = true;
        Iterator iterator = this.getCurrentEntity().iterator();
        while (iterator.hasNext()) {
            DaogenCatalogField field = (DaogenCatalogField)((Object)iterator.next());
            String columnType = this.getDaogenConfig().getTypeMapper().mapForModel(field);
            if (!columnType.equalsIgnoreCase(blobHandlerType) && !columnType.equalsIgnoreCase(clobHandlerType)) continue;
            String propertyName = GeneratorNameHelper.toPropertyName((String)field.getId());
            if (isFirst) {
                isFirst = false;
            } else {
                line.append(" && ");
            }
            line.append("(this." + MethodHelper.getGetterNameForProperty((String)propertyName) + "() == null)");
        }
    }

    private void generateDaogenBodyLobSetup(String blobHandlerType, String clobHandlerType) {
        Iterator iterator = this.getCurrentEntity().iterator();
        while (iterator.hasNext()) {
            String propertyNameH;
            String propertyName;
            DaogenCatalogField field = (DaogenCatalogField)((Object)iterator.next());
            String columnType = this.getDaogenConfig().getTypeMapper().mapForModel(field);
            if (columnType.equalsIgnoreCase(blobHandlerType)) {
                propertyName = GeneratorNameHelper.toPropertyName((String)field.getId());
                propertyNameH = propertyName + "Blob";
                this.getWriter().println("\t\t" + MethodHelper.getSetterNameForProperty((String)propertyNameH) + "( org.fugerit.java.core.db.daogen.LobHelper.createBlob( conn, " + MethodHelper.getGetterNameForProperty((String)propertyName) + "() ) );");
                continue;
            }
            if (!columnType.equalsIgnoreCase(clobHandlerType)) continue;
            propertyName = GeneratorNameHelper.toPropertyName((String)field.getId());
            propertyNameH = propertyName + "Clob";
            this.getWriter().println("\t\t" + MethodHelper.getSetterNameForProperty((String)propertyNameH) + "( org.fugerit.java.core.db.daogen.LobHelper.createClob( conn, " + MethodHelper.getGetterNameForProperty((String)propertyName) + "() ) );");
        }
    }

    private void generateDaogenBodyLob(boolean containsBlob, boolean containsClob, String blobHandlerType, String clobHandlerType) {
        if (containsBlob || containsClob) {
            this.getWriter().println("\tprivate boolean areLobsSet = false;");
            this.getWriter().println();
            this.getWriter().println("\tprotected boolean checkLobs() {");
            this.getWriter().println("\t\t// lobs must be set, or lobs properties must be null for writeSQL() to work");
            this.getWriter().println("\t\tboolean check = this.areLobsSet;");
            this.getWriter().println("\t\tif ( !check ) {");
            StringBuilder line = new StringBuilder();
            line.append("\t\t\tcheck = ");
            this.generateDaogenBodyLobField(blobHandlerType, clobHandlerType, line);
            line.append(";");
            this.getWriter().println((Object)line);
            this.getWriter().println("\t\t}");
            this.getWriter().println("\t\treturn check;");
            this.getWriter().println("\t}");
            this.getWriter().println();
            this.getWriter().println("\tpublic void setupLobs( java.sql.Connection conn ) throws SQLException {");
            this.generateDaogenBodyLobSetup(blobHandlerType, clobHandlerType);
            this.getWriter().println("\t\tthis.areLobsSet = true;");
            this.getWriter().println("\t}");
            this.getWriter().println();
            this.getWriter().println("\tpublic static " + this.getEntityStructName() + " wrap( " + this.getEntityModelName() + " model, java.sql.Connection conn ) throws SQLException {");
            this.getWriter().println("\t\t" + this.getEntityStructName() + " res = wrap( model );");
            this.getWriter().println("\t\t\tres.setupLobs( conn );");
            this.getWriter().println("\t\treturn res;");
            this.getWriter().println("\t}");
            this.getWriter().println();
            this.getWriter().println("\tpublic static " + this.getEntityStructName() + "[] wrap( " + this.getEntityModelName() + "[] list, java.sql.Connection conn ) throws SQLException {");
            this.getWriter().println("\t\t" + this.getEntityStructName() + "[] res = null;");
            this.getWriter().println("\t\tif ( list != null ) {");
            this.getWriter().println("\t\t\tres = new " + this.getEntityStructName() + "[ list.length ];");
            this.getWriter().println("\t\t\tfor ( int k=0; k<list.length; k++ ) {");
            this.getWriter().println("\t\t\t\tres[k] = wrap( list[k], conn );");
            this.getWriter().println("\t\t\t}");
            this.getWriter().println("\t\t}");
            this.getWriter().println("\t\treturn res;");
            this.getWriter().println("\t}");
            this.getWriter().println();
        }
    }

    private void handleField1(DaogenCatalogField field, String blobHandlerType, String clobHandlerType) {
        String columnTypeToLoad = this.getDaogenConfig().getTypeMapper().mapForModel(field);
        String javaSuffixToLoad = GeneratorNameHelper.toClassName((String)field.getId());
        String loadMethod = null;
        if (columnTypeToLoad.equalsIgnoreCase(String.class.getName())) {
            loadMethod = "stream.readString()";
        } else if (columnTypeToLoad.equalsIgnoreCase(BigDecimal.class.getName())) {
            loadMethod = "stream.readBigDecimal()";
        } else if (columnTypeToLoad.equalsIgnoreCase(Date.class.getName())) {
            loadMethod = "stream.readDate()";
        } else if (columnTypeToLoad.equalsIgnoreCase(Timestamp.class.getName()) || columnTypeToLoad.equalsIgnoreCase(java.util.Date.class.getName())) {
            loadMethod = "stream.readTimestamp()";
        } else if (columnTypeToLoad.equalsIgnoreCase(LocalDate.class.getName())) {
            loadMethod = "org.fugerit.java.core.db.daogen.SQLTypeConverter.utilDateToLocalDate( stream.readDate() )";
        } else if (columnTypeToLoad.equalsIgnoreCase(LocalDateTime.class.getName())) {
            loadMethod = "org.fugerit.java.core.db.daogen.SQLTypeConverter.utilDateToLocalDateTime( stream.readDate() )";
        } else if (columnTypeToLoad.equalsIgnoreCase(LocalTime.class.getName())) {
            loadMethod = "org.fugerit.java.core.db.daogen.SQLTypeConverter.utilDateToLocalTime( stream.readDate() )";
        } else if (columnTypeToLoad.equalsIgnoreCase(blobHandlerType)) {
            loadMethod = "org.fugerit.java.core.db.daogen.SQLTypeConverter.blobToByteHandler( (java.sql.Blob) stream.readObject() )";
        } else if (columnTypeToLoad.equalsIgnoreCase(clobHandlerType)) {
            loadMethod = "org.fugerit.java.core.db.daogen.SQLTypeConverter.clobToCharHandler( (java.sql.Clob) stream.readObject() )";
        } else if (field.isUserType()) {
            loadMethod = " ( (" + field.getStructType() + ") stream.readObject() ) ";
        } else {
            throw new ConfigRuntimeException("Type : " + columnTypeToLoad + " not handled yet!");
        }
        this.getWriter().println("\t\tthis.set" + javaSuffixToLoad + "( " + loadMethod + " );");
    }

    private void handleField2(DaogenCatalogField field, String blobHandlerType, String clobHandlerType) {
        String columnTypeToWrite = this.getDaogenConfig().getTypeMapper().mapForModel(field);
        String javaSuffixToWrite = GeneratorNameHelper.toClassName((String)field.getId());
        String writeMethod = null;
        if (columnTypeToWrite.equalsIgnoreCase(String.class.getName())) {
            writeMethod = "stream.writeString( FIELD-TOKEN )";
        } else if (columnTypeToWrite.equalsIgnoreCase(BigDecimal.class.getName())) {
            writeMethod = "stream.writeBigDecimal( FIELD-TOKEN )";
        } else if (columnTypeToWrite.equalsIgnoreCase(Date.class.getName())) {
            writeMethod = "stream.writeDate( org.fugerit.java.core.db.daogen.SQLTypeConverter.utilDateToSqlDate( FIELD-TOKEN ) )";
        } else if (columnTypeToWrite.equalsIgnoreCase(Timestamp.class.getName()) || columnTypeToWrite.equalsIgnoreCase(java.util.Date.class.getName())) {
            writeMethod = "stream.writeTimestamp( org.fugerit.java.core.db.daogen.SQLTypeConverter.utilDateToSqlTimestamp( FIELD-TOKEN ) )";
        } else if (columnTypeToWrite.equalsIgnoreCase(LocalDate.class.getName())) {
            writeMethod = "stream.writeDate( org.fugerit.java.core.db.daogen.SQLTypeConverter.localDateToSqlDate( FIELD-TOKEN ) )";
        } else if (columnTypeToWrite.equalsIgnoreCase(LocalDateTime.class.getName())) {
            writeMethod = "stream.writeTimestamp( org.fugerit.java.core.db.daogen.SQLTypeConverter.localDateTimeToSqlTimestamp( FIELD-TOKEN ) )";
        } else if (columnTypeToWrite.equalsIgnoreCase(LocalTime.class.getName())) {
            writeMethod = "stream.writeTime( org.fugerit.java.core.db.daogen.SQLTypeConverter.localTimeToSqlTime( FIELD-TOKEN ) )";
        } else if (columnTypeToWrite.equalsIgnoreCase(blobHandlerType)) {
            writeMethod = "stream.writeBlob( FIELD-TOKEN )";
            javaSuffixToWrite = javaSuffixToWrite + "Blob";
        } else if (columnTypeToWrite.equalsIgnoreCase(clobHandlerType)) {
            writeMethod = "stream.writeClob( FIELD-TOKEN )";
            javaSuffixToWrite = javaSuffixToWrite + "Clob";
        } else if (field.isUserType()) {
            writeMethod = "stream.writeObject( (" + field.getStructType() + ") FIELD-TOKEN )";
        } else {
            throw new ConfigRuntimeException("Type : " + columnTypeToWrite + " not handled yet!");
        }
        this.getWriter().println("\t\t" + writeMethod.replace("FIELD-TOKEN", "this.get" + javaSuffixToWrite + "()") + ";");
    }

    @Override
    public void generateDaogenBody() throws IOException {
        DaogenCatalogField field;
        this.addSerialVerUID();
        String blobHandlerType = this.getDaogenConfig().getTypeMapper().getTypeMapConfig().getProperty("model_java.sql.Blob");
        String clobHandlerType = this.getDaogenConfig().getTypeMapper().getTypeMapConfig().getProperty("model_java.sql.Clob");
        this.generateDaogenBodyStart();
        boolean containsBlob = false;
        boolean containsClob = false;
        Iterator iterator = this.getCurrentEntity().iterator();
        while (iterator.hasNext()) {
            field = (DaogenCatalogField)((Object)iterator.next());
            String columnType = this.getDaogenConfig().getTypeMapper().mapForModel(field);
            if (columnType.equalsIgnoreCase(blobHandlerType)) {
                containsBlob = true;
                PropertyUtils.newProperty(this.getWriter(), field.getId() + "_BLOB", TypeUtils.TYPE_BLOB, false, true);
                continue;
            }
            if (!columnType.equalsIgnoreCase(clobHandlerType)) continue;
            containsClob = true;
            PropertyUtils.newProperty(this.getWriter(), field.getId() + "_CLOB", TypeUtils.TYPE_CLOB, false, true);
        }
        this.generateDaogenBodyLob(containsBlob, containsClob, blobHandlerType, clobHandlerType);
        this.getWriter().println("\t@Override");
        this.getWriter().println("\tpublic void readSQL(SQLInput stream, String typeName) throws SQLException {");
        iterator = this.getCurrentEntity().iterator();
        while (iterator.hasNext()) {
            field = (DaogenCatalogField)((Object)iterator.next());
            this.handleField1(field, blobHandlerType, clobHandlerType);
        }
        this.getWriter().println("\t}");
        this.getWriter().println();
        this.getWriter().println("\t@Override");
        this.getWriter().println("\tpublic void writeSQL(SQLOutput stream) throws SQLException {");
        if (containsBlob || containsClob) {
            this.getWriter().println("\t\tif ( !this.checkLobs() ) {");
            this.getWriter().println("\t\t\torg.fugerit.java.core.db.daogen.BasicHelper.throwUnsupported( \"To use writeSQL() you must invoke setupLobs() for  \"+this.getSQLTypeName() );");
            this.getWriter().println("\t\t}");
            this.getWriter().println("\t\tthis.areLobsSet = false;\t// clob and blob will be used only once");
        }
        iterator = this.getCurrentEntity().iterator();
        while (iterator.hasNext()) {
            field = (DaogenCatalogField)((Object)iterator.next());
            this.handleField2(field, blobHandlerType, clobHandlerType);
        }
        this.getWriter().println("\t}");
        this.getWriter().println();
    }
}

