/*
 * Decompiled with CFR 0.152.
 */
package org.fugerit.java.daogen.base.gen;

import java.io.IOException;
import org.fugerit.java.core.cfg.ConfigException;
import org.fugerit.java.core.javagen.GeneratorNameHelper;
import org.fugerit.java.core.lang.helpers.BooleanUtils;
import org.fugerit.java.core.lang.helpers.StringUtils;
import org.fugerit.java.daogen.base.config.DaogenCatalogConfig;
import org.fugerit.java.daogen.base.config.DaogenCatalogConstants;
import org.fugerit.java.daogen.base.config.DaogenCatalogEntity;
import org.fugerit.java.daogen.base.config.DaogenCatalogField;
import org.fugerit.java.daogen.base.config.DaogenCatalogRelation;
import org.fugerit.java.daogen.base.config.DaogenClassConfigHelper;
import org.fugerit.java.daogen.base.gen.DaogenBasicGenerator;

public class WrapperGenerator
extends DaogenBasicGenerator {
    public static final String KEY = "WraoerGenerator";

    public String getKey() {
        return KEY;
    }

    @Override
    public void init(DaogenCatalogConfig daogenConfig, DaogenCatalogEntity entity) throws ConfigException {
        super.init(daogenConfig.getGeneralProp("src-main-java"), WrapperGenerator.fullObjectName(daogenConfig.getGeneralProp("package-helper"), DaogenCatalogConstants.wrapperName(entity)), "class", daogenConfig, entity);
        String daoWrapperNgMode = daogenConfig.getGeneralProp("dao-wrapper-ng-mode", "disabled");
        logger.info("{} -> {}", (Object)"dao-wrapper-ng-mode", (Object)daoWrapperNgMode);
        if ("disabled".equalsIgnoreCase(daoWrapperNgMode)) {
            this.setClassBaseWrapper(DaogenClassConfigHelper.addImport(daogenConfig, "dao.wrapper", this.getImportList()));
            this.setExtendsClass(this.getClassBaseWrapper() + "<" + this.getEntityModelName() + ">");
        } else if ("enabled".equalsIgnoreCase(daoWrapperNgMode)) {
            String wrapperNgClass = DaogenClassConfigHelper.findClassConfigProp(daogenConfig, "dao.wrapper.ng", "class");
            if (StringUtils.isNotEmpty((String)wrapperNgClass)) {
                this.setClassBaseWrapper(DaogenClassConfigHelper.addImport(daogenConfig, "dao.wrapper.ng", this.getImportList()));
                this.setExtendsClass(this.getClassBaseWrapper() + "<" + this.getEntityModelName() + ">");
            }
        } else {
            throw new ConfigException("Invalid dao-wrapper-ng-mode parameter : " + daoWrapperNgMode);
        }
        this.getImportList().add(this.getDaogenConfig().getGeneralProp("package-model") + "." + this.getEntityModelName());
        this.setImplementsInterface(this.getEntityModelName());
        for (DaogenCatalogRelation relation : this.getCurrentEntity().getRelations()) {
            DaogenCatalogEntity entityTo = (DaogenCatalogEntity)((Object)this.getDaogenConfig().getListMap(relation.getTo()));
            this.getImportList().add(this.getDaogenConfig().getGeneralProp("package-model") + "." + DaogenCatalogConstants.modelName(entityTo));
        }
    }

    private void generateRelations() {
        if (!this.getCurrentEntity().getRelations().isEmpty()) {
            this.getWriter().println("\t/*");
            this.getWriter().println("\t * fields generated for relations ");
            this.getWriter().println("\t */");
            this.getWriter().println();
            for (DaogenCatalogRelation relation : this.getCurrentEntity().getRelations()) {
                DaogenCatalogEntity entityTo = (DaogenCatalogEntity)((Object)this.getDaogenConfig().getListMap(relation.getTo()));
                String baseType = DaogenCatalogConstants.modelName(entityTo);
                String className = GeneratorNameHelper.toClassName((String)relation.getName());
                if ("many".equalsIgnoreCase(relation.getMode())) {
                    baseType = "java.util.List<" + baseType + ">";
                }
                this.getWriter().println("\t@Override");
                this.getWriter().println("\tpublic void set" + className + "( " + baseType + " value ) {");
                this.getWriter().println("\t\tthis.unwrapModel().set" + className + "( value );");
                this.getWriter().println("\t}");
                this.getWriter().println();
                this.getWriter().println("\t@Override");
                this.getWriter().println("\tpublic " + baseType + " get" + className + "() {");
                this.getWriter().println("\t\treturn this.unwrapModel().get" + className + "();");
                this.getWriter().println("\t}");
                this.getWriter().println();
            }
        }
    }

    @Override
    public void generateDaogenBody() throws IOException {
        String daoWrapperNgMode = this.getDaogenConfig().getGeneralProp("dao-wrapper-ng-mode", "disabled");
        this.generateSerial("disabled".equalsIgnoreCase(daoWrapperNgMode));
        this.getWriter().println("\tpublic " + this.getEntityWrapperName() + "( " + this.getEntityModelName() + " wrapped ) {");
        this.getWriter().println("\t\tsuper( wrapped );");
        this.getWriter().println("\t}");
        this.getWriter().println();
        this.getWriter().println("\tpublic " + this.getEntityModelName() + " unwrap( " + this.getEntityWrapperName() + " wrapper ) {");
        this.getWriter().println("\t\t" + this.getEntityModelName() + " res = wrapper;");
        if (this.isJdkVersionAtLeast(DaogenCatalogConstants.GEN_PROP_JDK_TARGET_VERSION_17)) {
            this.getWriter().println("\t\twhile ( res instanceof " + this.getEntityWrapperName() + " wrappedinstance ) { ");
            this.getWriter().println("\t\t\tres = wrappedinstance.unwrapModel();");
        } else {
            this.getWriter().println("\t\twhile ( res instanceof " + this.getEntityWrapperName() + " ) { ");
            this.getWriter().println("\t\t\tres = ((" + this.getEntityWrapperName() + ")res).unwrapModel();");
        }
        this.getWriter().println("\t\t}");
        this.getWriter().println("\t\treturn res;");
        this.getWriter().println("\t}");
        this.getWriter().println();
        boolean relationLast = "true".equalsIgnoreCase(this.getDaogenConfig().getGeneralProp("relations-last"));
        if (!relationLast) {
            this.generateRelations();
        }
        this.getWriter().println("\t/*");
        this.getWriter().println("\t * fields generated for entity attributes ");
        this.getWriter().println("\t */");
        for (DaogenCatalogField field : this.getCurrentEntity().getAllFields()) {
            String javaSuffix = GeneratorNameHelper.toClassName((String)field.getId());
            String realJavaType = this.getDaogenConfig().getTypeMapper().mapForModel(field);
            this.getWriter().println("\t@Override");
            this.getWriter().println("\tpublic void set" + javaSuffix + "( " + realJavaType + " value ) {");
            this.getWriter().println("\t\tthis.unwrapModel().set" + javaSuffix + "( value );");
            this.getWriter().println("\t}");
            this.getWriter().println();
            this.getWriter().println("\t@Override");
            this.getWriter().println("\tpublic " + realJavaType + " get" + javaSuffix + "() {");
            this.getWriter().println("\t\treturn this.unwrapModel().get" + javaSuffix + "();");
            this.getWriter().println("\t}");
            this.getWriter().println();
        }
        if (relationLast) {
            this.generateRelations();
        }
        if (BooleanUtils.isTrue((String)this.getDaogenConfig().getGeneralProp("check-empty-interface"))) {
            this.getWriter().println("\t@Override");
            this.getWriter().println("\tpublic boolean isEmpty() {");
            this.getWriter().println("\t\treturn this.unwrapModel().isEmpty();");
            this.getWriter().println("\t}");
            this.getWriter().println();
        }
    }
}

