/*
 * Decompiled with CFR 0.152.
 */
package org.fugerit.java.daogen.base.gen.helper;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import lombok.Generated;
import org.fugerit.java.core.cfg.ConfigException;
import org.fugerit.java.core.javagen.GeneratorNameHelper;
import org.fugerit.java.core.lang.helpers.ConcatHelper;
import org.fugerit.java.core.lang.helpers.StringUtils;
import org.fugerit.java.daogen.base.config.DaogenCatalogConfig;
import org.fugerit.java.daogen.base.config.DaogenCatalogConstants;
import org.fugerit.java.daogen.base.config.DaogenCatalogEntity;
import org.fugerit.java.daogen.base.config.DaogenCatalogField;
import org.fugerit.java.daogen.base.config.DaogenCatalogRelation;
import org.fugerit.java.daogen.base.config.DaogenClassConfigHelper;
import org.fugerit.java.daogen.base.config.DaogenCustomCode;
import org.fugerit.java.daogen.base.config.DaogenHelperGenerator;
import org.fugerit.java.daogen.base.gen.DaogenBasicGenerator;
import org.fugerit.java.daogen.base.gen.GeneratorKeyHelper;
import org.fugerit.java.daogen.base.gen.util.FacadeGeneratorUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseRestLoadHelperGenerator
extends DaogenBasicGenerator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BaseRestLoadHelperGenerator.class);
    protected static final String NEW_CONTEXT_LIT = "try (CloseableDAOContext context = this.newDefaultContext() ) {";
    protected static final String CATCH_LIT = "} catch(Exception e) {";
    protected static final String ERROR_LOAD_LIT = "logger.error(\"ERROR - REST- Load";
    protected static final String PRODUCE_JSON_LIT = "@Produces(MediaType.APPLICATION_JSON)";
    protected static final String RESPONSE_RES_NULL_LIT = "Response res = null;";
    protected static final String FACTORY_LIT = " factory = (";
    protected static final String ATT_NAME_LIT = ".ATT_NAME );";
    protected static final String LIST_LIT = "<List<";
    protected static final String CONTEXT_GET_ATTRIBUTE_LIT = ") context.getAttribute(";
    protected static final String FACADE_FACTORY_GET_LIT = " facade = factory.get";
    private String propertyPackage;
    private String key;
    protected String helperClass = null;

    protected BaseRestLoadHelperGenerator(String key, String propertyPackage) {
        this.key = key;
        this.propertyPackage = propertyPackage;
    }

    public String getKey() {
        return this.key;
    }

    @Override
    public boolean isGenerate(DaogenCatalogConfig daogenConfig, DaogenCatalogEntity entity) {
        return FacadeGeneratorUtils.isFacadeGenerate(entity);
    }

    protected void populateImportListBase() {
        String jeeTarget = this.getJeeTargetMode();
        this.getImportList().add("java.util.List");
        this.getImportList().add(jeeTarget + ".ws.rs.GET");
        this.getImportList().add(jeeTarget + ".ws.rs.Path");
        this.getImportList().add(jeeTarget + ".ws.rs.PathParam");
        this.getImportList().add(jeeTarget + ".ws.rs.Produces");
        this.getImportList().add(jeeTarget + ".ws.rs.core.MediaType");
        this.getImportList().add(jeeTarget + ".ws.rs.core.Response");
    }

    @Override
    public void init(DaogenCatalogConfig daogenConfig, DaogenCatalogEntity entity) throws ConfigException {
        String fullObjectBName = BaseRestLoadHelperGenerator.fullObjectName(daogenConfig.getGeneralProp(this.propertyPackage), DaogenCatalogConstants.restLoadName(entity));
        log.info("propertyPackage:{}, fullObjectBName:{}", (Object)this.propertyPackage, (Object)fullObjectBName);
        super.init(DaogenHelperGenerator.toHelperSourceFolder(daogenConfig), DaogenHelperGenerator.toHelperClassName(fullObjectBName), "class", daogenConfig, entity);
        this.populateImportListBase();
        this.setClassDaogenContext(DaogenClassConfigHelper.addImport(daogenConfig, "dao.context", this.getImportList()));
        this.setClassCloseableDaogenContext(DaogenClassConfigHelper.addImport(daogenConfig, "dao.closeablecontext", this.getImportList()));
        this.setClassDaoException(DaogenClassConfigHelper.addImport(daogenConfig, "dao.exception", this.getImportList()));
        this.setClassBaseResult(DaogenClassConfigHelper.addImport(daogenConfig, "dao.result", this.getImportList()));
        this.setClassServiceResult(DaogenClassConfigHelper.addImport(daogenConfig, "dao.serviceresult", this.getImportList()));
        this.getImportList().add(this.getDaogenConfig().getGeneralProp("package-model") + "." + this.getEntityModelName());
        this.helperClass = this.getDaogenConfig().getGeneralProp("package-helper") + "." + this.getEntityHelperName();
        this.getImportList().add(this.getDaogenConfig().getGeneralProp("package-facade-def") + "." + this.getEntityFinderName());
        this.getImportList().add(this.getDaogenConfig().getGeneralProp("package-facade-def") + "." + this.getEntityFacadeDefName());
        String facadeDef = this.getDaogenConfig().getGeneralProp("factory-def");
        if (facadeDef != null) {
            this.getImportList().add(facadeDef);
        }
        this.setExtendsClass(this.getDaogenConfig().getGeneralProp("base-rest-service") + "<" + this.getEntityModelName() + ">");
    }

    private void printPrimaryKeyLoader(GeneratorKeyHelper primaryKeyHelper, boolean deep) {
        String deepUrl = "";
        String deepMethod = "";
        String deepWorker = "";
        if (deep) {
            deepUrl = "/deep";
            deepMethod = "deep";
            deepWorker = "Deep";
        }
        this.printPrimaryKeyLoader(primaryKeyHelper, deepUrl, deepMethod, deepWorker);
    }

    protected abstract void printPrimaryKeyLoader(GeneratorKeyHelper var1, String var2, String var3, String var4);

    protected abstract void printLoadAll(String var1);

    protected abstract void printLoadCurrent(String var1, String var2, String var3, DaogenCatalogField var4);

    private void generateDaogenBodyHandleLoadDeep(String factoryClassName, GeneratorKeyHelper primaryKeyHelper) {
        this.getWriter().println("\tpublic static " + this.getClassServiceResult() + "<" + this.getEntityModelName() + "> " + "loadById" + "DeepWorker( DAOContext context, " + primaryKeyHelper.getKeyParams() + " ) throws " + this.getClassDaoException() + " {");
        this.getWriter().println("\t\t" + factoryClassName + FACTORY_LIT + factoryClassName + CONTEXT_GET_ATTRIBUTE_LIT + factoryClassName + ATT_NAME_LIT);
        this.getWriter().println("\t\t" + this.getEntityFacadeDefName() + FACADE_FACTORY_GET_LIT + this.getEntityFacadeDefName() + "();");
        this.getWriter().println("\t\t" + this.getEntityModelName() + " model = facade.loadById( context , " + primaryKeyHelper.getForwardParams() + " );");
        this.getWriter().println("\t\t" + this.getClassServiceResult() + "<" + this.getEntityModelName() + ">  result = " + this.getClassServiceResult() + ".newDefaultResult( model );");
        if (!this.getCurrentEntity().getRelations().isEmpty()) {
            this.getWriter().println("\t\tif ( result.getContent() != null ) {");
            for (DaogenCatalogRelation rel : this.getCurrentEntity().getRelations()) {
                DaogenCatalogEntity entityTo = (DaogenCatalogEntity)((Object)this.getDaogenConfig().getListMap(rel.getTo()));
                GeneratorKeyHelper relKeyHelper = new GeneratorKeyHelper(this.getDaogenConfig(), entityTo, entityTo.getPrimaryKey()).setForLoadInterface();
                if ("many".equalsIgnoreCase(rel.getMode()) && relKeyHelper.getKeyFields().size() == 1) {
                    String javaName = GeneratorNameHelper.toClassName((String)rel.getKey());
                    String relMethod = DaogenCatalogConstants.restLoadName(entityTo) + ".loadBy" + javaName + "( context, result.getContent().get" + GeneratorNameHelper.toClassName((String)this.getCurrentEntity().getPrimaryKey()) + "() ).getContent()";
                    this.getWriter().println("\t\t\tresult.getContent().set" + GeneratorNameHelper.toClassName((String)rel.getName()) + "(" + relMethod + ");");
                    continue;
                }
                GeneratorKeyHelper relKeyHelper1 = new GeneratorKeyHelper(this.getDaogenConfig(), this.getCurrentEntity(), rel.getKey()).setForLoadInterface();
                ArrayList<String> keyList = new ArrayList<String>();
                for (String currentFieldKey : relKeyHelper1.getKeyFields()) {
                    keyList.add("result.getContent().get" + GeneratorNameHelper.toClassName((String)currentFieldKey) + "()");
                }
                String keyFields = ConcatHelper.concat((String)",", (String[])keyList.toArray(new String[0]));
                String relMethod = DaogenCatalogConstants.restLoadName(entityTo) + "." + "loadById" + "Worker( context, " + keyFields + " ).getContent()";
                this.getWriter().println("\t\t\tresult.getContent().set" + GeneratorNameHelper.toClassName((String)rel.getName()) + "(" + relMethod + ");");
            }
            this.getWriter().println("\t\t}");
        }
        this.getWriter().println("\t\treturn result;");
        this.getWriter().println("\t}");
        this.getWriter().println();
        this.printPrimaryKeyLoader(primaryKeyHelper, true);
        this.getWriter().println();
    }

    private void generateDaogenBodyHandleField() {
        Iterator iterator = this.getCurrentEntity().iterator();
        while (iterator.hasNext()) {
            DaogenCatalogField field = (DaogenCatalogField)((Object)iterator.next());
            String javaType = this.getDaogenConfig().getTypeMapper().mapForModel(field);
            if (field.getId().equalsIgnoreCase(this.getCurrentEntity().getPrimaryKey()) || !javaType.equalsIgnoreCase("java.lang.String") && !javaType.equals("java.math.BigDecimal")) continue;
            String javaName = GeneratorNameHelper.toClassName((String)field.getId());
            String urlName = field.getId().toLowerCase();
            String propertyName = GeneratorNameHelper.toPropertyName((String)urlName);
            DaogenCustomCode.addCommentRest("rest.worker", DaogenCustomCode.INDENT_1, (PrintWriter)this.getWriter(), this.getEntityModelName(), propertyName, "current");
            this.getWriter().println("\tpublic static " + this.getClassServiceResult() + LIST_LIT + this.getEntityModelName() + ">> loadBy" + javaName + "( DAOContext context, " + javaType + " current ) throws " + this.getClassDaoException() + " {");
            this.getWriter().println("\t\t" + this.helperClass + " model = new " + this.helperClass + "();");
            this.getWriter().println("\t\tmodel.set" + javaName + "( current );");
            this.getWriter().println("\t\t" + this.getClassServiceResult() + LIST_LIT + this.getEntityModelName() + ">>  result = loadByModelWorker( context , model );");
            this.getWriter().println("\t\treturn result;");
            this.getWriter().println("\t}");
            this.getWriter().println();
            this.printLoadCurrent(urlName, propertyName, javaName, field);
            this.getWriter().println();
        }
    }

    @Override
    public void generateDaogenBody() throws IOException {
        String daoRestNgMode = this.getDaogenConfig().getGeneralProp("dao-rest-ng-mode", "disabled");
        this.generateSerial("disabled".equalsIgnoreCase(daoRestNgMode));
        String factoryClassName = GeneratorNameHelper.classFromPackage((String)this.getDaogenConfig().getGeneralProp("factory-def"));
        if (StringUtils.isNotEmpty((String)this.getCurrentEntity().getPrimaryKey())) {
            GeneratorKeyHelper primaryKeyHelper = new GeneratorKeyHelper(this.getDaogenConfig(), this.getCurrentEntity(), this.getCurrentEntity().getPrimaryKey()).setForLoadInterface();
            this.getWriter().println("\tpublic static " + this.getClassServiceResult() + "<" + this.getEntityModelName() + "> " + "loadById" + "Worker( DAOContext context, " + primaryKeyHelper.getKeyParams() + " ) throws " + this.getClassDaoException() + " {");
            this.getWriter().println("\t\t" + factoryClassName + FACTORY_LIT + factoryClassName + CONTEXT_GET_ATTRIBUTE_LIT + factoryClassName + ATT_NAME_LIT);
            this.getWriter().println("\t\t" + this.getEntityFacadeDefName() + FACADE_FACTORY_GET_LIT + this.getEntityFacadeDefName() + "();");
            this.getWriter().println("\t\t" + this.getEntityModelName() + " model = facade.loadById( context , " + primaryKeyHelper.getForwardParams() + " );");
            this.getWriter().println("\t\t" + this.getClassServiceResult() + "<" + this.getEntityModelName() + ">  result = " + this.getClassServiceResult() + ".newDefaultResult( model );");
            this.getWriter().println("\t\treturn result;");
            this.getWriter().println("\t}");
            this.getWriter().println();
            this.printPrimaryKeyLoader(primaryKeyHelper, false);
            this.getWriter().println();
            this.generateDaogenBodyHandleLoadDeep(factoryClassName, primaryKeyHelper);
        }
        this.printLoadAll(factoryClassName);
        this.getWriter().println();
        DaogenCustomCode.addCommentRest("rest.worker", DaogenCustomCode.INDENT_1, (PrintWriter)this.getWriter(), this.getEntityModelName(), this.getEntityModelName(), "model");
        this.getWriter().println("\tpublic static " + this.getClassServiceResult() + LIST_LIT + this.getEntityModelName() + ">> loadByModelWorker( DAOContext context, " + this.getEntityModelName() + " model ) throws " + this.getClassDaoException() + " {");
        this.getWriter().println("\t\t" + this.getEntityFinderName() + " finder = " + this.getEntityFinderName() + ".newInstance( model );");
        this.getWriter().println("\t\t" + factoryClassName + FACTORY_LIT + factoryClassName + CONTEXT_GET_ATTRIBUTE_LIT + factoryClassName + ATT_NAME_LIT);
        this.getWriter().println("\t\t" + this.getEntityFacadeDefName() + FACADE_FACTORY_GET_LIT + this.getEntityFacadeDefName() + "();");
        this.getWriter().println("\t\t" + this.getClassBaseResult() + "<" + this.getEntityModelName() + "> resultFacade = facade.loadAllByFinder( context , finder );");
        this.getWriter().println("\t\t" + this.getClassServiceResult() + LIST_LIT + this.getEntityModelName() + ">>  result = " + this.getClassServiceResult() + ".newDefaultResult( resultFacade.getList() );");
        this.getWriter().println("\t\treturn result;");
        this.getWriter().println("\t}");
        this.getWriter().println();
        this.generateDaogenBodyHandleField();
    }
}

