/*
 * Decompiled with CFR 0.152.
 */
package org.fugerit.java.daogen.base.gen.helper;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.List;
import lombok.Generated;
import org.fugerit.java.core.cfg.ConfigException;
import org.fugerit.java.core.function.SafeFunction;
import org.fugerit.java.daogen.base.config.DaogenCatalogConfig;
import org.fugerit.java.daogen.base.config.DaogenCatalogConstants;
import org.fugerit.java.daogen.base.config.DaogenCatalogEntity;
import org.fugerit.java.daogen.base.config.DaogenHelperGenerator;
import org.fugerit.java.daogen.base.gen.DaogenBasicGenerator;
import org.fugerit.java.daogen.base.gen.util.FacadeGeneratorUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseRestLoadRealGenerator
extends DaogenBasicGenerator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BaseRestLoadRealGenerator.class);
    private String key;
    private List<String> importList;
    private String propertyPackage;
    private String patternBaseAnnotation;
    private String patternPathAnnotation;

    public BaseRestLoadRealGenerator(String key, List<String> importList, String propertyParage, String patternBaseAnnotation, String patternPathAnnotation) {
        this.key = key;
        this.importList = importList;
        this.propertyPackage = propertyParage;
        log.debug("patternBaseAnnotation:{}, patternPathAnnotation:{}", (Object)patternBaseAnnotation, (Object)patternPathAnnotation);
        this.patternBaseAnnotation = patternBaseAnnotation;
        this.patternPathAnnotation = patternPathAnnotation;
    }

    public String getKey() {
        return this.key;
    }

    @Override
    public boolean isGenerate(DaogenCatalogConfig daogenConfig, DaogenCatalogEntity entity) {
        return FacadeGeneratorUtils.isFacadeGenerate(entity);
    }

    @Override
    public void init(DaogenCatalogConfig daogenConfig, DaogenCatalogEntity entity) throws ConfigException {
        String fullObjectBName = BaseRestLoadRealGenerator.fullObjectName(daogenConfig.getGeneralProp(this.propertyPackage), DaogenCatalogConstants.restLoadName(entity));
        log.debug("propertyPackage:{}, fullObjectBName:{}", (Object)this.propertyPackage, (Object)fullObjectBName);
        super.init(daogenConfig.getGeneralProp("src-main-java"), fullObjectBName, "class", daogenConfig, entity);
        for (String currentImport : this.importList) {
            this.getImportList().add(currentImport);
        }
        this.setExtendsClass(DaogenHelperGenerator.toHelperClassName(this.getJavaName()));
        try {
            this.checkSkipRealClass();
        }
        catch (IOException e) {
            throw new ConfigException((Throwable)e);
        }
    }

    @Override
    protected void beforeClass() {
        super.beforeClass();
        String urlBase = this.getCurrentEntity().getName().replace("_", "").toLowerCase();
        SafeFunction.applyIfNotNull((Object)this.patternBaseAnnotation, () -> this.getWriter().println(this.patternBaseAnnotation));
        log.debug("patternPathAnnotation : {}, urlBase : {}", (Object)this.patternPathAnnotation, (Object)urlBase);
        String pathAnnotation = MessageFormat.format(this.patternPathAnnotation, urlBase);
        log.debug("pathAnnotation : {}", (Object)pathAnnotation);
        this.getWriter().println(pathAnnotation);
    }

    @Override
    public void generateDaogenBody() throws IOException {
        this.addSerialVerUID();
        this.println("\t// [HELPER/IMPL MODEL] this class is a stub and can be modified as you see fit (it will not been overwritten)");
    }
}

