/*
 * Decompiled with CFR 0.152.
 */
package org.fugerit.java.daogen.base.gen.helper;

import org.fugerit.java.daogen.base.config.DaogenCatalogField;
import org.fugerit.java.daogen.base.gen.GeneratorKeyHelper;
import org.fugerit.java.daogen.base.gen.helper.BaseRestLoadHelperGenerator;

public class RestLoadHelperGenerator
extends BaseRestLoadHelperGenerator {
    public static final String KEY = RestLoadHelperGenerator.class.getSimpleName();

    public RestLoadHelperGenerator() {
        super(KEY, "package-rest-load");
    }

    @Override
    protected void printPrimaryKeyLoader(GeneratorKeyHelper primaryKeyHelper, String deepUrl, String deepMethod, String deepWorker) {
        this.getWriter().println("\t@GET");
        this.getWriter().println("\t@Path(\"" + deepUrl + primaryKeyHelper.getUrlParams() + "\")");
        this.getWriter().println("\t@Produces(MediaType.APPLICATION_JSON)");
        this.getWriter().println("\tpublic Response getByID" + deepMethod + "(" + primaryKeyHelper.getPathParams() + ") throws Exception {");
        this.getWriter().println("\t\tResponse res = null;");
        this.getWriter().println("\t\ttry (CloseableDAOContext context = this.newDefaultContext() ) {");
        this.getWriter().println("\t\t\t" + this.getClassServiceResult() + "<" + this.getEntityModelName() + ">  result = " + "loadById" + deepWorker + "Worker( context, " + primaryKeyHelper.getRestParams() + " );");
        this.getWriter().println("\t\t\tres = this.createResponseFromObject( result );");
        this.getWriter().println("\t\t} catch(Exception e) {");
        this.getWriter().println("\t\t\tlogger.error(\"ERROR - REST- Load" + this.getCurrentEntity().toClassName() + " - getByID - \"+e, e );");
        this.getWriter().println("\t\t}");
        this.getWriter().println("\t\treturn res;");
        this.getWriter().println("\t}");
    }

    @Override
    protected void printLoadAll(String factoryClassName) {
        this.getWriter().println("\t@GET");
        this.getWriter().println("\t@Path(\"/all\")");
        this.getWriter().println("\t@Produces(MediaType.APPLICATION_JSON)");
        this.getWriter().println("\tpublic Response getAll() throws Exception {");
        this.getWriter().println("\t\tResponse res = null;");
        this.getWriter().println("\t\ttry (CloseableDAOContext context = this.newDefaultContext() ) {");
        this.getWriter().println("\t\t" + factoryClassName + " factory = (" + factoryClassName + ") context.getAttribute(" + factoryClassName + ".ATT_NAME );");
        this.getWriter().println("\t\t" + this.getEntityFacadeDefName() + " facade = factory.get" + this.getEntityFacadeDefName() + "();");
        this.getWriter().println("\t\t\t" + this.getClassBaseResult() + "<" + this.getEntityModelName() + "> resultFacade = facade.loadAll( context );");
        this.getWriter().println("\t\t\t" + this.getClassServiceResult() + "<List<" + this.getEntityModelName() + ">>  result = " + this.getClassServiceResult() + ".newDefaultResult( resultFacade.getList() );");
        this.getWriter().println("\t\t\tres = this.createResponseFromList( result );");
        this.getWriter().println("\t\t} catch(Exception e) {");
        this.getWriter().println("\t\t\tlogger.error(\"ERROR - REST- Load" + this.getCurrentEntity().toClassName() + " - getAll - \"+e, e );");
        this.getWriter().println("\t\t}");
        this.getWriter().println("\t\treturn res;");
        this.getWriter().println("\t}");
    }

    @Override
    protected void printLoadCurrent(String urlName, String propertyName, String javaName, DaogenCatalogField field) {
        this.getWriter().println("\t@GET");
        this.getWriter().println("\t@Path(\"/" + urlName + "/{" + urlName + "}\")");
        this.getWriter().println("\t@Produces(MediaType.APPLICATION_JSON)");
        this.getWriter().println("\tpublic Response getAll" + javaName + "(@PathParam( \"" + urlName + "\" ) String " + propertyName + ") throws Exception {");
        this.getWriter().println("\t\tResponse res = null;");
        this.getWriter().println("\t\ttry (CloseableDAOContext context = this.newDefaultContext() ) {");
        if (field.getJavaType().equals("java.lang.String")) {
            this.getWriter().println("\t\t\tString value = " + propertyName + ";");
        } else {
            this.getWriter().println("\t\t\tjava.math.BigDecimal value = new java.math.BigDecimal(" + propertyName + ");");
        }
        this.getWriter().println("\t\t\t" + this.getClassServiceResult() + "<List<" + this.getEntityModelName() + ">>  result = loadBy" + javaName + "( context, value );");
        this.getWriter().println("\t\t\tres = this.createResponseFromList( result );");
        this.getWriter().println("\t\t} catch(Exception e) {");
        this.getWriter().println("\t\t\tlogger.error(\"ERROR - REST- Load" + this.getCurrentEntity().toClassName() + " - getAll" + javaName + " - \"+e, e );");
        this.getWriter().println("\t\t}");
        this.getWriter().println("\t\treturn res;");
        this.getWriter().println("\t}");
    }
}

