/*
 * Decompiled with CFR 0.152.
 */
package org.fugerit.java.daogen.base.gen.helper;

import org.fugerit.java.daogen.base.config.DaogenCatalogField;
import org.fugerit.java.daogen.base.gen.GeneratorKeyHelper;
import org.fugerit.java.daogen.base.gen.helper.BaseRestLoadHelperGenerator;

public class SpringBootLoadHelperGenerator
extends BaseRestLoadHelperGenerator {
    public static final String KEY = SpringBootLoadHelperGenerator.class.getSimpleName();
    private static final String RESPONSE_ENTITY_LIT = "ResponseEntity<Object> res = null;";
    private static final String RES_BUILD_LIT = "res = ResponseEntity.status( HttpServletResponse.SC_INTERNAL_SERVER_ERROR ).build();";

    public SpringBootLoadHelperGenerator() {
        super(KEY, "package-spring-rest-load");
    }

    @Override
    protected void populateImportListBase() {
        String jeeTarget = this.getJeeTargetMode();
        this.getImportList().add("java.util.List");
        this.getImportList().add(jeeTarget + ".servlet.http.HttpServletResponse");
        this.getImportList().add("org.springframework.http.ResponseEntity");
        this.getImportList().add("org.springframework.web.bind.annotation.PathVariable");
        this.getImportList().add("org.springframework.web.bind.annotation.GetMapping");
        this.getImportList().add("org.springframework.http.MediaType");
    }

    @Override
    protected void printPrimaryKeyLoader(GeneratorKeyHelper primaryKeyHelper, String deepUrl, String deepMethod, String deepWorker) {
        this.getWriter().println("\t@GetMapping(value = \"" + deepUrl + primaryKeyHelper.getUrlParams() + "\", produces = MediaType.APPLICATION_JSON_VALUE )");
        this.getWriter().println("\tpublic ResponseEntity<Object> getByID" + deepMethod + "(" + primaryKeyHelper.getPathVarables() + ") throws Exception {");
        this.getWriter().println("\t\tResponseEntity<Object> res = null;");
        this.getWriter().println("\t\ttry (CloseableDAOContext context = this.newDefaultContext() ) {");
        this.getWriter().println("\t\t\t" + this.getClassServiceResult() + "<" + this.getEntityModelName() + ">  result = " + "loadById" + deepWorker + "Worker( context, " + primaryKeyHelper.getRestParams() + " );");
        this.getWriter().println("\t\t\tres = ResponseEntity.ok().contentType(MediaType.APPLICATION_JSON).body( this.createResultFromObject( result ) );");
        this.getWriter().println("\t\t} catch(Exception e) {");
        this.getWriter().println("\t\t\tlogger.error(\"ERROR - REST- Load" + this.getCurrentEntity().toClassName() + " - getByID - \"+e, e );");
        this.getWriter().println("\t\t\tres = ResponseEntity.status( HttpServletResponse.SC_INTERNAL_SERVER_ERROR ).build();");
        this.getWriter().println("\t\t}");
        this.getWriter().println("\t\treturn res;");
        this.getWriter().println("\t}");
    }

    @Override
    protected void printLoadAll(String factoryClassName) {
        this.getWriter().println("\t@GetMapping(value = \"/all\", produces = MediaType.APPLICATION_JSON_VALUE )");
        this.getWriter().println("\tpublic ResponseEntity<Object> getAll() throws Exception {");
        this.getWriter().println("\t\tResponseEntity<Object> res = null;");
        this.getWriter().println("\t\ttry (CloseableDAOContext context = this.newDefaultContext() ) {");
        this.getWriter().println("\t\t" + factoryClassName + " factory = (" + factoryClassName + ") context.getAttribute(" + factoryClassName + ".ATT_NAME );");
        this.getWriter().println("\t\t" + this.getEntityFacadeDefName() + " facade = factory.get" + this.getEntityFacadeDefName() + "();");
        this.getWriter().println("\t\t\t" + this.getClassBaseResult() + "<" + this.getEntityModelName() + "> resultFacade = facade.loadAll( context );");
        this.getWriter().println("\t\t\t" + this.getClassServiceResult() + "<List<" + this.getEntityModelName() + ">>  result = " + this.getClassServiceResult() + ".newDefaultResult( resultFacade.getList() );");
        this.getWriter().println("\t\t\tres = ResponseEntity.ok().contentType(MediaType.APPLICATION_JSON).body( this.createResultFromList( result) );");
        this.getWriter().println("\t\t} catch(Exception e) {");
        this.getWriter().println("\t\t\tlogger.error(\"ERROR - REST- Load" + this.getCurrentEntity().toClassName() + " - getAll - \"+e, e );");
        this.getWriter().println("\t\t\tres = ResponseEntity.status( HttpServletResponse.SC_INTERNAL_SERVER_ERROR ).build();");
        this.getWriter().println("\t\t}");
        this.getWriter().println("\t\treturn res;");
        this.getWriter().println("\t}");
    }

    @Override
    protected void printLoadCurrent(String urlName, String propertyName, String javaName, DaogenCatalogField field) {
        this.getWriter().println("\t@GetMapping(value = \"/" + urlName + "/{" + urlName + "}\", produces = MediaType.APPLICATION_JSON_VALUE )");
        this.getWriter().println("\tpublic ResponseEntity<Object> getAll" + javaName + "(@PathVariable( \"" + urlName + "\" ) String " + propertyName + ") throws Exception {");
        this.getWriter().println("\t\tResponseEntity<Object> res = null;");
        this.getWriter().println("\t\ttry (CloseableDAOContext context = this.newDefaultContext() ) {");
        if (field.getJavaType().equals("java.lang.String")) {
            this.getWriter().println("\t\t\tString value = " + propertyName + ";");
        } else {
            this.getWriter().println("\t\t\tjava.math.BigDecimal value = new java.math.BigDecimal(" + propertyName + ");");
        }
        this.getWriter().println("\t\t\t" + this.getClassServiceResult() + "<List<" + this.getEntityModelName() + ">>  result = loadBy" + javaName + "( context, value );");
        this.getWriter().println("\t\t\tres = ResponseEntity.ok().contentType(MediaType.APPLICATION_JSON).body( this.createResultFromList( result ) );");
        this.getWriter().println("\t\t} catch(Exception e) {");
        this.getWriter().println("\t\t\tlogger.error(\"ERROR - REST- Load" + this.getCurrentEntity().toClassName() + " - getAll" + javaName + " - \"+e, e );");
        this.getWriter().println("\t\t\tres = ResponseEntity.status( HttpServletResponse.SC_INTERNAL_SERVER_ERROR ).build();");
        this.getWriter().println("\t\t}");
        this.getWriter().println("\t\treturn res;");
        this.getWriter().println("\t}");
    }
}

