/*
 * Decompiled with CFR 0.152.
 */
package org.fugerit.java.daogen.base.gen.util;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import org.fugerit.java.core.javagen.GeneratorNameHelper;
import org.fugerit.java.core.lang.helpers.BooleanUtils;
import org.fugerit.java.core.lang.helpers.StringUtils;
import org.fugerit.java.daogen.base.config.DaogenCatalogConfig;
import org.fugerit.java.daogen.base.config.DaogenCatalogConstants;
import org.fugerit.java.daogen.base.config.DaogenCatalogEntity;
import org.fugerit.java.daogen.base.config.DaogenCatalogField;
import org.fugerit.java.daogen.base.config.DaogenCatalogRelation;
import org.fugerit.java.daogen.base.gen.DaogenBasicGenerator;
import org.fugerit.java.daogen.base.gen.util.GenUtils;

public class UnitTestHelper {
    private UnitTestHelper() {
    }

    public static void genInitBasicTest(DaogenBasicGenerator gen, int junitLevel) {
        if (junitLevel < 5) {
            GenUtils.addAll(gen.getImportList(), "org.junit.Assert", "org.junit.Test");
        } else {
            GenUtils.addAll(gen.getImportList(), "org.junit.jupiter.api.Assertions", "org.junit.jupiter.api.Test");
        }
        GenUtils.addAll(gen.getImportList(), "org.slf4j.Logger", "org.slf4j.LoggerFactory", gen.getDaogenConfig().getGeneralProp("package-model") + "." + gen.getEntityModelName(), gen.getDaogenConfig().getGeneralProp("package-helper") + "." + gen.getEntityHelperName(), gen.getDaogenConfig().getGeneralProp("package-helper") + "." + gen.getEntityWrapperName());
        if (StringUtils.isNotEmpty((String)gen.getDaogenConfig().getGeneralProp("package-facade-def"))) {
            GenUtils.addAll(gen.getImportList(), gen.getDaogenConfig().getGeneralProp("package-facade-def") + "." + gen.getEntityFinderName());
        }
    }

    public static void genBodyBasicTest(DaogenBasicGenerator gen, int junitLevel) {
        String assertionClass = "Assertions";
        String appendPublic = "";
        if (junitLevel < 5) {
            assertionClass = "Assert";
            appendPublic = "public";
            GenUtils.addLogger(gen, DaogenCatalogConstants.junit4ModelName(gen.getCurrentEntity()));
        } else {
            GenUtils.addLogger(gen, DaogenCatalogConstants.junit5ModelName(gen.getCurrentEntity()));
        }
        gen.getWriter().println();
        UnitTestHelper.createSampleEntityPrintAllMethod(gen);
        UnitTestHelper.createSampleEntityInstanceMethod(gen, assertionClass);
        gen.getWriter().println("\t@Test");
        gen.getWriter().println("\t" + appendPublic + " void testJUnit" + junitLevel + "Model" + GeneratorNameHelper.toClassName((String)gen.getCurrentEntity().getName()) + "() { ");
        gen.getWriter().println("\t\t" + gen.getEntityModelName() + " current = this.newInstance();");
        gen.getWriter().println("\t\tthis.printAll( current );");
        String daoHelperNgMode = gen.getDaogenConfig().getGeneralProp("dao-helper-ng-mode", "disabled");
        gen.getWriter().println("\t\tlogger.info( \"current toString() : {}\", current );");
        if ("disabled".equalsIgnoreCase(daoHelperNgMode)) {
            gen.getWriter().println("\t\torg.fugerit.java.core.function.SafeFunction.apply( () -> org.fugerit.java.core.io.ObjectIO.fullSerializationTest( current ) );");
        }
        gen.getWriter().println("\t\t" + assertionClass + ".assertNotNull( current );");
        UnitTestHelper.generateFinderTest(gen, assertionClass);
        gen.getWriter().println("\t}");
        gen.getWriter().println();
    }

    private static void generateFinderTest(DaogenBasicGenerator gen, String assertionClass) {
        if (StringUtils.isNotEmpty((String)gen.getDaogenConfig().getGeneralProp("package-facade-def"))) {
            gen.getWriter().println("\t\t" + gen.getEntityFinderName() + " finder1 = new " + gen.getEntityFinderName() + "();");
            gen.getWriter().println("\t\tfinder1.setModel( current );");
            gen.getWriter().println("\t\tlogger.info( \"finder1.getModel() -> {}\", finder1.getModel() );");
            if (gen.getCurrentEntity().containsDefaultId()) {
                gen.getWriter().println("\t\tfinder1.setId( current.getId() );");
                gen.getWriter().println("\t\t" + assertionClass + ".assertEquals( current.getId(), finder1.getId() );");
                gen.getWriter().println("\t\t" + assertionClass + ".assertNotNull( " + gen.getEntityFinderName() + ".newInstance( current.getId() ) );");
            }
            gen.getWriter().println("\t\t" + assertionClass + ".assertNotNull( " + gen.getEntityFinderName() + ".newInstance( current ) );");
            gen.getWriter().println("\t\t" + assertionClass + ".assertNotNull( finder1 );");
        }
    }

    private static void createSampleEntityPrintAllMethod(DaogenBasicGenerator gen) {
        gen.getWriter().println("\tpublic void printAll( " + gen.getEntityModelName() + " current ) { ");
        Iterator iterator = gen.getCurrentEntity().iterator();
        while (iterator.hasNext()) {
            DaogenCatalogField field = (DaogenCatalogField)((Object)iterator.next());
            gen.getWriter().println("\t\tlogger.info( \"" + field.getId() + "-> {}\", current.get" + GeneratorNameHelper.toClassName((String)field.getId()) + "() );");
        }
        for (DaogenCatalogRelation relation : gen.getCurrentEntity().getRelations()) {
            String className = GeneratorNameHelper.toClassName((String)relation.getName());
            gen.getWriter().println("\t\tlogger.info( \"relation : " + relation.getId() + "-> {}\", current.get" + className + "() );");
        }
        gen.getWriter().println("\t}");
        gen.getWriter().println();
    }

    private static void createSampleEntityInstanceMethod(DaogenBasicGenerator gen, String assertionClass) {
        gen.getWriter().println("\tpublic " + gen.getEntityModelName() + " newInstance() { ");
        gen.getWriter().println("\t\t" + gen.getEntityWrapperName() + " current = new " + gen.getEntityWrapperName() + "( new " + gen.getEntityHelperName() + "() );");
        boolean checkIsEmpty = BooleanUtils.isTrue((String)gen.getDaogenConfig().getGeneralProp("check-empty-interface"));
        if (checkIsEmpty) {
            gen.getWriter().println("\t\t" + assertionClass + ".assertTrue( current.isEmpty() );");
        }
        for (DaogenCatalogField field : gen.getCurrentEntity().getAllFields()) {
            UnitTestHelper.handleFieldNewInstance(gen.getDaogenConfig(), field, (PrintWriter)gen.getWriter());
            if (!checkIsEmpty) continue;
            gen.getWriter().println("\t\t" + assertionClass + ".assertFalse( current.isEmpty() );");
        }
        for (DaogenCatalogRelation relation : gen.getCurrentEntity().getRelations()) {
            DaogenCatalogEntity entityTo = (DaogenCatalogEntity)((Object)gen.getDaogenConfig().getListMap(relation.getTo()));
            String className = GeneratorNameHelper.toClassName((String)relation.getName());
            String baseType = gen.getDaogenConfig().getGeneralProp("package-helper") + "." + DaogenCatalogConstants.helperName(entityTo);
            if ("many".equalsIgnoreCase(relation.getMode())) {
                baseType = ArrayList.class.getName() + "<" + gen.getDaogenConfig().getGeneralProp("package-model") + "." + DaogenCatalogConstants.modelName(entityTo) + ">";
            }
            gen.getWriter().println("\t\tcurrent.set" + className + "( new " + baseType + "() );");
        }
        gen.getWriter().println("\t\tlogger.info( \"unwrap :  {}\", current.unwrap( current ) );");
        gen.getWriter().println("\t\treturn current;");
        gen.getWriter().println("\t}");
        gen.getWriter().println();
    }

    private static void handleFieldNewInstance(DaogenCatalogConfig config, DaogenCatalogField field, PrintWriter writer) {
        String columnType = config.getTypeMapper().mapForModel(field);
        StringBuilder line = new StringBuilder();
        line.append("\t\t");
        line.append("current.set");
        line.append(GeneratorNameHelper.toClassName((String)field.getId()));
        line.append("(");
        if (columnType.equalsIgnoreCase("java.lang.String")) {
            line.append("\"1\"");
        } else if (columnType.equalsIgnoreCase("java.math.BigDecimal")) {
            line.append("new java.math.BigDecimal( \"1\" )");
        } else if (columnType.equalsIgnoreCase("java.lang.Integer")) {
            line.append("1");
        } else if (columnType.equalsIgnoreCase("java.sql.Date")) {
            line.append("new java.sql.Date( System.currentTimeMillis )");
        } else if (columnType.equalsIgnoreCase("java.sql.Timestamp")) {
            line.append("new java.sql.Timestamp( System.currentTimeMillis )");
        } else if (columnType.equalsIgnoreCase("java.util.Date")) {
            line.append("new java.util.Date()");
        } else {
            line.append("null");
        }
        line.append(");");
        writer.println(line.toString());
    }
}

