/*
 * Decompiled with CFR 0.152.
 */
package org.fugerit.java.daogen.maven;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Properties;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.fugerit.java.core.lang.helpers.StringUtils;
import org.fugerit.java.daogen.base.config.DaogenFacade;

public abstract class AbstractMojoGenerate
extends AbstractMojo {
    public static final String PARAM_DAOGEN_CONFIG = "daogen.config";
    public static final String PARAM_GENERATED_SOURCE_HELPER = "generated.source.helper";
    @Parameter(property="daogenConfig", required=true, alias="daogen.config")
    protected String daogenConfig;
    @Parameter(property="genBaseDir", required=true, alias="base-src-folder")
    protected String genBaseDir;
    @Parameter(property="generatedSourceHelper", required=false, alias="src-mvn-generated-sources")
    protected String generatedSourceHelper;
    @Parameter(property="generatorCatalog", required=false, alias="generator-catalog")
    protected String generatorCatalog;
    @Parameter(property="decoratorCatalog", required=false, alias="decorator-catalog")
    protected String decoratorCatalog;

    private void addProperty(Properties overrideProperties, String key, String value) {
        if (StringUtils.isNotEmpty((String)value)) {
            this.getLog().info((CharSequence)("override property, key : " + key + ", value : " + value));
            overrideProperties.setProperty(key, value);
        }
    }

    public void execute() throws MojoExecutionException {
        this.getLog().info((CharSequence)("using parameter daogen.config : " + this.daogenConfig));
        File file = new File(this.daogenConfig);
        try {
            this.getLog().info((CharSequence)("daogen config path : " + file.getCanonicalPath()));
            Properties overrideProperties = new Properties();
            this.addProperty(overrideProperties, "base-src-folder", this.genBaseDir);
            this.addProperty(overrideProperties, "src-mvn-generated-sources", this.generatedSourceHelper);
            this.addProperty(overrideProperties, "generator-catalog", this.generatorCatalog);
            this.addProperty(overrideProperties, "decorator-catalog", this.decoratorCatalog);
            try (FileInputStream fis = new FileInputStream(file);){
                DaogenFacade.generate((InputStream)fis, (Properties)overrideProperties);
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error generating code : " + e, e);
        }
    }
}

