/*
 * Decompiled with CFR 0.152.
 */
package org.fugerit.java.doc.lib.autodoc.parser.model;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import lombok.Generated;
import org.fugerit.java.doc.lib.autodoc.parser.model.AutodocElement;
import org.fugerit.java.doc.lib.autodoc.parser.model.AutodocSimpleType;
import org.fugerit.java.doc.lib.autodoc.parser.model.AutodocType;
import org.fugerit.java.doc.lib.autodoc.parser.model.AutodocUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmlet.xsdparser.core.XsdParser;
import org.xmlet.xsdparser.xsdelements.XsdComplexType;
import org.xmlet.xsdparser.xsdelements.XsdElement;
import org.xmlet.xsdparser.xsdelements.XsdNamedElements;
import org.xmlet.xsdparser.xsdelements.XsdSimpleType;

public class AutodocModel
implements Serializable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AutodocModel.class);
    public static final String ATT_NAME = "autodocModel";
    private static final long serialVersionUID = 5016692762844545990L;
    private final LinkedHashMap<String, AutodocElement> elements = new LinkedHashMap();
    private final LinkedHashMap<String, AutodocType> types = new LinkedHashMap();
    private final LinkedHashMap<String, AutodocSimpleType> simpleTypes = new LinkedHashMap();
    private final transient XsdParser xsdParser;
    private String version;
    private String title;
    private String xsdPrefix;
    private String autodocPrefix;

    public AutodocModel(XsdParser xsdParser) {
        this.xsdParser = xsdParser;
    }

    public AutodocElement addElement(XsdElement xsdElement) {
        AutodocElement element = new AutodocElement(this, xsdElement);
        this.elements.put(element.getKey(), element);
        return element;
    }

    public AutodocType addType(XsdComplexType xsdComplexType) {
        AutodocType type = new AutodocType(xsdComplexType);
        String key = AutodocUtils.toKey((XsdNamedElements)xsdComplexType);
        log.debug("xsdComplexType key : {}", (Object)key);
        this.types.put(key, type);
        return type;
    }

    public AutodocSimpleType addSimpleType(XsdSimpleType xsdSimpleType) {
        AutodocSimpleType type = new AutodocSimpleType(this, xsdSimpleType);
        String key = AutodocUtils.toKey((XsdNamedElements)xsdSimpleType);
        log.debug("xsdSimpleType key : {}", (Object)key);
        this.simpleTypes.put(key, type);
        return type;
    }

    public Collection<String> getElementNames() {
        return this.elements.keySet();
    }

    public Collection<AutodocElement> getElements() {
        return Collections.unmodifiableCollection(this.elements.values());
    }

    public AutodocElement getElement(String name) {
        return this.elements.get(name);
    }

    public boolean containsName(String name) {
        return this.elements.containsKey(name);
    }

    public Collection<AutodocType> getTypes() {
        return Collections.unmodifiableCollection(this.types.values());
    }

    public Collection<AutodocSimpleType> getSimpleTypes() {
        return Collections.unmodifiableCollection(this.simpleTypes.values());
    }

    @Generated
    public XsdParser getXsdParser() {
        return this.xsdParser;
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @Generated
    public void setVersion(String version) {
        this.version = version;
    }

    @Generated
    public String getTitle() {
        return this.title;
    }

    @Generated
    public void setTitle(String title) {
        this.title = title;
    }

    @Generated
    public String getXsdPrefix() {
        return this.xsdPrefix;
    }

    @Generated
    public void setXsdPrefix(String xsdPrefix) {
        this.xsdPrefix = xsdPrefix;
    }

    @Generated
    public String getAutodocPrefix() {
        return this.autodocPrefix;
    }

    @Generated
    public void setAutodocPrefix(String autodocPrefix) {
        this.autodocPrefix = autodocPrefix;
    }
}

