/*
 * Decompiled with CFR 0.152.
 */
package org.fugerit.java.nhg;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.fugerit.java.core.function.SafeFunction;
import org.fugerit.java.core.lang.helpers.StringUtils;
import org.fugerit.java.nhg.JacksonHelper;
import org.fugerit.java.nhg.reflect.config.Entry;
import org.fugerit.java.nhg.reflect.config.EntryField;
import org.fugerit.java.nhg.reflect.config.EntryMethod;

public class GenerateReflectConfig {
    private ObjectWriter writer;

    public GenerateReflectConfig(ObjectWriter writer) {
        this.writer = writer;
    }

    public GenerateReflectConfig() {
        this(JacksonHelper.newObjectMapper().writerWithDefaultPrettyPrinter());
    }

    private static String keyEntryField(EntryField o) {
        return o.getName();
    }

    private static String keyEntryMethod(EntryMethod o) {
        return o.getName() + "-" + StringUtils.concat((String)",", o.getParameterTypes());
    }

    public void normalizeSort(List<Entry> reflectConfig) {
        for (Entry e : reflectConfig) {
            if (e.getFields() != null) {
                Collections.sort(e.getFields(), Comparator.comparing(GenerateReflectConfig::keyEntryField));
            }
            if (e.getMethods() == null) continue;
            Collections.sort(e.getMethods(), Comparator.comparing(GenerateReflectConfig::keyEntryMethod));
        }
    }

    public void generate(Writer out, List<Entry> reflectConfig) {
        SafeFunction.apply(() -> {
            this.normalizeSort(reflectConfig);
            ObjectMapper mapper = JacksonHelper.newObjectMapper();
            mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            this.writer.writeValue(out, (Object)reflectConfig);
        });
    }
}

