/*
 * Decompiled with CFR 0.152.
 */
package org.fugerit.java.nhg;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.fugerit.java.core.cfg.ConfigRuntimeException;
import org.fugerit.java.core.function.SafeFunction;
import org.fugerit.java.nhg.JacksonHelper;
import org.fugerit.java.nhg.reflect.config.Entry;

public class MergeConfigUtil {
    private static final ObjectMapper MAPPER = JacksonHelper.newObjectMapper();

    private MergeConfigUtil() {
    }

    public static void addFolder(List<Entry> entries, File reflectConfigFolder) {
        if (!reflectConfigFolder.isDirectory()) {
            throw new ConfigRuntimeException(String.format("Must be a folder : %s", reflectConfigFolder));
        }
        Arrays.stream(reflectConfigFolder.listFiles(f -> f.getName().endsWith("json"))).sorted(Comparator.comparing(File::getName)).forEach(f -> MergeConfigUtil.add(entries, f));
    }

    public static void add(List<Entry> entries, File reflectConfigFile) {
        SafeFunction.apply(() -> {
            try (FileReader reflectConfigReader = new FileReader(reflectConfigFile);){
                MergeConfigUtil.add(entries, reflectConfigReader);
            }
        });
    }

    public static void add(List<Entry> entries, Reader reflectConfigReader) {
        SafeFunction.apply(() -> {
            List addEntries = (List)MAPPER.readValue(reflectConfigReader, (TypeReference)new TypeReference<List<Entry>>(){});
            entries.addAll(addEntries);
        });
    }
}

