/*
 * Decompiled with CFR 0.152.
 */
package org.fugerit.java.nhg.config;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.ClassPath;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import lombok.Generated;
import org.fugerit.java.core.cfg.ConfigRuntimeException;
import org.fugerit.java.core.function.SafeFunction;
import org.fugerit.java.core.io.helper.StreamHelper;
import org.fugerit.java.core.lang.helpers.ClassHelper;
import org.fugerit.java.core.lang.helpers.StringUtils;
import org.fugerit.java.core.util.ObjectUtils;
import org.fugerit.java.nhg.GenerateReflectConfig;
import org.fugerit.java.nhg.JacksonHelper;
import org.fugerit.java.nhg.ReflectConfigUtil;
import org.fugerit.java.nhg.config.PackageLookupHelper;
import org.fugerit.java.nhg.config.model.GenerateConfig;
import org.fugerit.java.nhg.config.model.NativeHelperConfig;
import org.fugerit.java.nhg.reflect.config.Entry;
import org.fugerit.java.nhg.reflect.config.EntryCondition;
import org.fugerit.java.nhg.reflect.config.EntryHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NativeHelperFacade {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NativeHelperFacade.class);
    public static final String MODE_GETTERS = "getters";
    public static final String MODE_SETTERS = "setters";
    public static final String MODE_GETTERS_SETTERS = "getters_setters";
    public static final String MODE_ALL = "all";
    public static final String PARAM_REFLECT_CONFIG_JSON_OUTPUT_PATH = "reflectConfigJsonOutputPath";
    public static final String MERGE_MODE_FAIL_ON_ERROR = "failOnError";
    public static final String MERGE_MODE_WARN_ON_ERROR = "warnOnError";
    private static final ObjectMapper JSON_MAPPER = JacksonHelper.newObjectMapper();

    private NativeHelperFacade() {
    }

    public static NativeHelperConfig loadConfig(String path) {
        return (NativeHelperConfig)SafeFunction.get(() -> {
            try (InputStream is = StreamHelper.resolveStream((String)path);){
                YAMLMapper mapper = new YAMLMapper();
                NativeHelperConfig config = (NativeHelperConfig)ObjectUtils.objectWithDefault((Object)((NativeHelperConfig)mapper.readValue(is, NativeHelperConfig.class)), (Object)new NativeHelperConfig());
                if (config.getGenerate() == null) {
                    config.setGenerate(new ArrayList<GenerateConfig>());
                }
                NativeHelperConfig nativeHelperConfig = config;
                return nativeHelperConfig;
            }
        });
    }

    private static ReflectConfigUtil getUtils(String mode) {
        switch (mode) {
            case "getters": {
                return ReflectConfigUtil.GETTERS_ONLY;
            }
            case "setters": {
                return ReflectConfigUtil.SETTERS_ONLY;
            }
            case "getters_setters": {
                return ReflectConfigUtil.GETTERS_SETTERS;
            }
            case "all": {
                return ReflectConfigUtil.ALL_METHODS;
            }
        }
        throw new ConfigRuntimeException(String.format("Mode not found %s", mode));
    }

    private static void handleClass(Class<?> c, List<Entry> list, GenerateConfig g) {
        ReflectConfigUtil utils = NativeHelperFacade.getUtils(g.getMode());
        Entry entry = utils.toEntry(c, !g.isSkipConstructors());
        if (StringUtils.isNotEmpty((String)g.getTypeReachable())) {
            entry.setCondition(new EntryCondition(g.getTypeReachable()));
        }
        EntryHelper.fixedOrder(entry);
        list.add(entry);
    }

    private static void merge(NativeHelperConfig config, List<Entry> list) {
        SafeFunction.applyIfNotNull(config.getMerge(), () -> config.getMerge().forEach(m -> {
            Consumer exceptionConsumer = MERGE_MODE_FAIL_ON_ERROR.equalsIgnoreCase(m.getMode()) ? SafeFunction.EX_CONSUMER_THROW_CONFIG_RUNTIME : SafeFunction.EX_CONSUMER_TRACE_WARN;
            SafeFunction.apply(() -> {
                log.info("merge config : {}", m);
                try (FileReader fis = new FileReader(m.getReflectConfigPath());){
                    list.addAll((Collection)JSON_MAPPER.readValue((Reader)fis, (TypeReference)new TypeReference<List<Entry>>(){}));
                }
            }, (Consumer)exceptionConsumer);
        }));
    }

    private static Collection<Class<?>> lookup(NativeHelperConfig config, GenerateConfig g) {
        log.info("lookup package : {}", (Object)g.getPackageName());
        return (Collection)SafeFunction.get(() -> {
            if (config.isJarPackageDiscovery() || g.isJarPackageDiscovery()) {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                ClassPath cp = ClassPath.from((ClassLoader)cl);
                ImmutableSet allClasses = cp.getTopLevelClasses(g.getPackageName());
                return allClasses.stream().map(ci -> (Class)SafeFunction.get(() -> cl.loadClass(ci.getName()))).collect(Collectors.toList());
            }
            return PackageLookupHelper.findAllClassesUsingClassLoader(g.getPackageName());
        });
    }

    public static List<Entry> generateEntries(NativeHelperConfig config) {
        ArrayList<Entry> list = new ArrayList<Entry>();
        config.getGenerate().forEach(g -> {
            if (StringUtils.isNotEmpty((String)g.getClassName())) {
                Class c2 = (Class)SafeFunction.get(() -> ClassHelper.getDefaultClassLoader().loadClass(g.getClassName()));
                log.info("generate class reflect config : {}", (Object)c2);
                NativeHelperFacade.handleClass(c2, list, g);
            } else if (StringUtils.isNotEmpty((String)g.getPackageName())) {
                HashSet<String> excludeClassNames = new HashSet<String>();
                if (StringUtils.isNotEmpty((String)g.getExcludeClassNames())) {
                    excludeClassNames.addAll(Arrays.asList(g.getExcludeClassNames().split(",")));
                }
                NativeHelperFacade.lookup(config, g).stream().filter(c -> !excludeClassNames.contains(c.getSimpleName())).sorted(Comparator.comparing(Class::getSimpleName)).forEach(c -> {
                    log.info("generate class reflect config : {} (from package : {})", c, (Object)g.getPackageName());
                    NativeHelperFacade.handleClass(c, list, g);
                });
            } else {
                throw new ConfigRuntimeException("className or packageName must be provided for each entry");
            }
        });
        NativeHelperFacade.merge(config, list);
        return list;
    }

    public static List<Entry> generate(NativeHelperConfig config, File file) throws IOException {
        try (FileWriter writer = new FileWriter(file);){
            List<Entry> list = NativeHelperFacade.generate(config, writer);
            return list;
        }
    }

    public static List<Entry> generate(NativeHelperConfig config, Writer reflectConfigJsonWriter) {
        List<Entry> entries = NativeHelperFacade.generateEntries(config);
        GenerateReflectConfig generateReflectConfig = new GenerateReflectConfig();
        generateReflectConfig.generate(reflectConfigJsonWriter, entries);
        return entries;
    }

    public static NativeHelperConfig loadAndGenerate(String nativeHelperConfigPath) throws IOException {
        File reflectConfigJsonFile;
        NativeHelperConfig config = NativeHelperFacade.loadConfig(nativeHelperConfigPath);
        String reflectConfigJsonOutputPath = config.getReflectConfigJsonOutputPath();
        if (StringUtils.isNotEmpty((String)reflectConfigJsonOutputPath)) {
            reflectConfigJsonFile = new File(reflectConfigJsonOutputPath);
            if (config.isCreateParentDirectory()) {
                log.info("createParentDirectory : {} -> {}", (Object)reflectConfigJsonFile.getParentFile(), (Object)reflectConfigJsonFile.getParentFile().mkdirs());
            }
        } else {
            throw new ConfigRuntimeException(String.format("Param %s not set.", PARAM_REFLECT_CONFIG_JSON_OUTPUT_PATH));
        }
        NativeHelperFacade.generate(config, reflectConfigJsonFile);
        return config;
    }
}

