/*
 * Decompiled with CFR 0.152.
 */
package org.fugerit.java.nhg.config;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.fugerit.java.core.cfg.ConfigRuntimeException;
import org.fugerit.java.core.function.SafeFunction;
import org.fugerit.java.core.lang.helpers.ClassHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PackageLookupHelper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PackageLookupHelper.class);

    private PackageLookupHelper() {
    }

    public static Set<Class<?>> findAllClassesUsingClassLoader(String packageName) throws ConfigRuntimeException {
        return (Set)SafeFunction.get(() -> {
            InputStream stream = ClassHelper.getDefaultClassLoader().getResourceAsStream(packageName.replaceAll("[.]", "/"));
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
            return reader.lines().filter(line -> line.endsWith(".class")).map(line -> PackageLookupHelper.getClass(line, packageName)).collect(Collectors.toSet());
        });
    }

    private static Class<?> getClass(String className, String packageName) {
        return (Class)SafeFunction.get(() -> {
            log.debug("packageName : {}, className : {}", (Object)packageName, (Object)className);
            return ClassHelper.getDefaultClassLoader().loadClass(packageName + "." + className.substring(0, className.lastIndexOf(46)));
        });
    }
}

