/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.cqrs4j;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Semaphore;
import javax.validation.Validator;
import javax.validation.constraints.NotNull;
import org.fuin.cqrs4j.AggregateCommand;
import org.fuin.cqrs4j.DataResult;
import org.fuin.cqrs4j.Result;
import org.fuin.cqrs4j.SimpleResult;
import org.fuin.ddd4j.ddd.EntityId;
import org.fuin.ddd4j.ddd.EntityIdPath;
import org.fuin.objects4j.common.ConstraintViolationException;
import org.fuin.objects4j.common.Contract;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Cqrs4JUtils {
    public static final List<Class<?>> JAXB_CLASSES = Collections.unmodifiableList(Arrays.asList(DataResult.class, SimpleResult.class, ConstraintViolationException.class));
    private static final Logger LOG = LoggerFactory.getLogger(Cqrs4JUtils.class);
    public static final String PRECONDITION_VIOLATED = "PRECONDITION_VIOLATED";
    public static final String PARAM_ENTITY_PATH_NOT_EQUAL_CMD_ENTITY_PATH = "PARAM_ENTITY_PATH_NOT_EQUAL_CMD_ENTITY_PATH";
    public static final String SHORT_ID_PREFIX = "CQRS4J";

    private Cqrs4JUtils() {
        throw new UnsupportedOperationException();
    }

    public static void tryLocked(@NotNull Semaphore lock, @NotNull Runnable code) {
        Contract.requireArgNotNull((String)"lock", (Object)lock);
        Contract.requireArgNotNull((String)"code", (Object)code);
        if (lock.tryAcquire()) {
            try {
                code.run();
            }
            finally {
                lock.release();
            }
        }
    }

    public static void runLocked(@NotNull Semaphore lock, @NotNull Runnable code) {
        Contract.requireArgNotNull((String)"lock", (Object)lock);
        Contract.requireArgNotNull((String)"code", (Object)code);
        try {
            lock.acquire();
            try {
                code.run();
            }
            finally {
                lock.release();
            }
        }
        catch (InterruptedException ex) {
            LOG.warn("Couldn't clear view", (Throwable)ex);
        }
    }

    public static Result<?> verifyPrecondition(@NotNull Validator validator, @NotNull Object obj) {
        Contract.requireArgNotNull((String)"validator", (Object)validator);
        Contract.requireArgNotNull((String)"obj", (Object)obj);
        Set violations = validator.validate(obj, new Class[0]);
        if (violations.isEmpty()) {
            return null;
        }
        String errors = Contract.asString((Set)violations, (String)", ");
        LOG.error(errors);
        return SimpleResult.error(PRECONDITION_VIOLATED, errors);
    }

    @SafeVarargs
    public static <ID extends EntityId> Result<?> verifyParamEntityIdPathEqualsCmdEntityIdPath(@NotNull AggregateCommand<?, ?> cmd, ID ... entityIds) {
        Contract.requireArgNotNull((String)"cmd", cmd);
        Contract.requireArgNotNull((String)"entityIds", entityIds);
        EntityIdPath paramPath = new EntityIdPath(entityIds);
        if (paramPath.equals((Object)cmd.getEntityIdPath())) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (ID entityId : entityIds) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(entityId.asTypedString());
        }
        String msg = "Entity path constructred from URL parameters " + sb + " is not the same as command's entityPath: '" + cmd.getEntityIdPath() + "'";
        LOG.error(msg + " [PARAM_ENTITY_PATH_NOT_EQUAL_CMD_ENTITY_PATH]");
        return SimpleResult.error(PARAM_ENTITY_PATH_NOT_EQUAL_CMD_ENTITY_PATH, msg);
    }
}

