/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.cqrs4j;

import javax.json.bind.annotation.JsonbProperty;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.fuin.cqrs4j.AbstractResult;
import org.fuin.cqrs4j.ResultType;
import org.fuin.objects4j.common.Contract;
import org.fuin.objects4j.common.MarshalInformation;
import org.fuin.objects4j.common.Nullable;
import org.fuin.objects4j.ui.Label;
import org.fuin.objects4j.ui.Prompt;
import org.fuin.objects4j.ui.ShortLabel;
import org.fuin.objects4j.ui.Tooltip;

@XmlRootElement(name="result")
public final class DataResult<DATA>
extends AbstractResult<DATA> {
    private static final long serialVersionUID = 1000L;
    static final String DATA_CLASS_PROPERTY = "data-class";
    static final String DATA_ELEMENT_PROPERTY = "data-element";
    @JsonbProperty(value="data-class")
    @XmlTransient
    private String dataClass;
    @JsonbProperty(value="data-element")
    @XmlTransient
    private String dataElement;
    @Label(value="Data")
    @ShortLabel(value="DATA")
    @Tooltip(value="Optional result data")
    @Prompt(value="Optional Data")
    @Valid
    @XmlAnyElement(lax=true)
    private Object data;

    protected DataResult() {
    }

    public DataResult(@NotNull ResultType type, @Nullable String code, @Nullable String message, @Nullable DATA data) {
        super(type, code, message);
        if (data instanceof MarshalInformation) {
            MarshalInformation mui = (MarshalInformation)data;
            this.data = mui.getData();
            this.dataClass = mui.getDataClass().getName();
            this.dataElement = mui.getDataElement();
        } else {
            this.data = data;
            this.dataClass = null;
            this.dataElement = null;
        }
    }

    public DataResult(@NotNull ResultType type, @Nullable String code, @Nullable String message, @Nullable DATA data, String dataElement) {
        super(type, code, message);
        this.data = data;
        if (data == null) {
            this.dataClass = null;
            this.dataElement = null;
        } else {
            this.dataClass = data.getClass().getName();
            this.dataElement = dataElement;
        }
    }

    public DataResult(@NotNull Exception exception) {
        super(exception);
        if (exception instanceof MarshalInformation) {
            MarshalInformation mui = (MarshalInformation)exception;
            this.data = mui.getData();
            this.dataClass = mui.getDataClass().getName();
            this.dataElement = mui.getDataElement();
        } else {
            this.data = null;
            this.dataClass = null;
            this.dataElement = null;
        }
    }

    public final String getDataClass() {
        return this.dataClass;
    }

    public final String getDataElement() {
        return this.dataElement;
    }

    @Override
    @Nullable
    public final DATA getData() {
        return (DATA)this.data;
    }

    public final int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getCode() == null ? 0 : this.getCode().hashCode());
        result = 31 * result + (this.getMessage() == null ? 0 : this.getMessage().hashCode());
        result = 31 * result + (this.getType() == null ? 0 : this.getType().hashCode());
        result = 31 * result + (this.dataClass == null ? 0 : this.dataClass.hashCode());
        result = 31 * result + (this.dataElement == null ? 0 : this.dataElement.hashCode());
        result = 31 * result + (this.data == null ? 0 : this.data.hashCode());
        return result;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DataResult other = (DataResult)obj;
        if (this.getCode() == null ? other.getCode() != null : !this.getCode().equals(other.getCode())) {
            return false;
        }
        if (this.getMessage() == null ? other.getMessage() != null : !this.getMessage().equals(other.getMessage())) {
            return false;
        }
        if (this.getType() != other.getType()) {
            return false;
        }
        if (this.dataClass == null ? other.dataClass != null : !this.dataClass.equals(other.dataClass)) {
            return false;
        }
        if (this.dataElement == null ? other.dataElement != null : !this.dataElement.equals(other.dataElement)) {
            return false;
        }
        return !(this.data == null ? other.data != null : !this.data.equals(other.data));
    }

    public final String toString() {
        return "Result [type=" + this.getType() + ", code=" + this.getCode() + ", message=" + this.getMessage() + ", dataClass=" + this.dataClass + ", dataElement=" + this.dataElement + "]";
    }

    public static DataResult<Void> ok() {
        return new DataResult<Object>(ResultType.OK, null, null, null);
    }

    public static <T> DataResult<T> ok(@Nullable T data) {
        return new DataResult<T>(ResultType.OK, null, null, data);
    }

    public static <T> DataResult<T> ok(@Nullable T data, String dataElement) {
        return new DataResult<T>(ResultType.OK, null, null, data, dataElement);
    }

    public static <T> DataResult<T> error(@NotNull String code, @NotNull String message) {
        Contract.requireArgNotNull((String)"code", (Object)code);
        Contract.requireArgNotNull((String)"message", (Object)message);
        return new DataResult<Object>(ResultType.ERROR, code, message, null);
    }
}

