/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.cqrs4j;

import jakarta.json.bind.annotation.JsonbProperty;
import jakarta.json.bind.annotation.JsonbTypeAdapter;
import jakarta.validation.constraints.NotNull;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.fuin.cqrs4j.AbstractCommand;
import org.fuin.cqrs4j.AggregateCommand;
import org.fuin.ddd4j.ddd.AggregateRootId;
import org.fuin.ddd4j.ddd.AggregateVersion;
import org.fuin.ddd4j.ddd.AggregateVersionConverter;
import org.fuin.ddd4j.ddd.EntityId;
import org.fuin.ddd4j.ddd.EntityIdPath;
import org.fuin.ddd4j.ddd.EntityIdPathConverter;
import org.fuin.ddd4j.ddd.Event;
import org.fuin.ddd4j.ddd.EventId;
import org.fuin.objects4j.common.Contract;
import org.fuin.objects4j.common.Nullable;

public abstract class AbstractAggregateCommand<ROOT_ID extends AggregateRootId, ENTITY_ID extends EntityId>
extends AbstractCommand
implements AggregateCommand<ROOT_ID, ENTITY_ID> {
    private static final long serialVersionUID = 1000L;
    @NotNull
    @JsonbTypeAdapter(value=EntityIdPathConverter.class)
    @JsonbProperty(value="entity-id-path")
    @XmlJavaTypeAdapter(value=EntityIdPathConverter.class)
    @XmlElement(name="entity-id-path")
    private EntityIdPath entityIdPath;
    @Nullable
    @JsonbTypeAdapter(value=AggregateVersionConverter.class)
    @JsonbProperty(value="aggregate-version")
    @XmlJavaTypeAdapter(value=AggregateVersionConverter.class)
    @XmlElement(name="aggregate-version")
    private AggregateVersion aggregateVersion;

    protected AbstractAggregateCommand() {
    }

    public AbstractAggregateCommand(@NotNull AggregateRootId aggregateRootId, @Nullable AggregateVersion aggregateVersion) {
        this(new EntityIdPath(new EntityId[]{aggregateRootId}), aggregateVersion);
    }

    public AbstractAggregateCommand(@NotNull EntityIdPath entityIdPath, @Nullable AggregateVersion aggregateVersion) {
        Contract.requireArgNotNull((String)"entityIdPath", (Object)entityIdPath);
        this.entityIdPath = entityIdPath;
        this.aggregateVersion = aggregateVersion;
    }

    public AbstractAggregateCommand(@NotNull EntityIdPath entityIdPath, @Nullable AggregateVersion aggregateVersion, @NotNull Event respondTo) {
        super(respondTo);
        Contract.requireArgNotNull((String)"entityIdPath", (Object)entityIdPath);
        this.entityIdPath = entityIdPath;
        this.aggregateVersion = aggregateVersion;
    }

    public AbstractAggregateCommand(@NotNull EntityIdPath entityIdPath, @Nullable AggregateVersion aggregateVersion, @Nullable EventId correlationId, @Nullable EventId causationId) {
        super(correlationId, causationId);
        Contract.requireArgNotNull((String)"entityIdPath", (Object)entityIdPath);
        this.entityIdPath = entityIdPath;
        this.aggregateVersion = aggregateVersion;
    }

    @NotNull
    public final EntityIdPath getEntityIdPath() {
        return this.entityIdPath;
    }

    @NotNull
    public final ENTITY_ID getEntityId() {
        return (ENTITY_ID)this.entityIdPath.last();
    }

    @Override
    @Nullable
    public final ROOT_ID getAggregateRootId() {
        return (ROOT_ID)((AggregateRootId)this.entityIdPath.first());
    }

    @Nullable
    public final AggregateVersion getAggregateVersion() {
        return this.aggregateVersion;
    }

    @Nullable
    public final Integer getAggregateVersionInteger() {
        if (this.aggregateVersion == null) {
            return null;
        }
        return this.aggregateVersion.asBaseType();
    }

    protected static abstract class Builder<ROOT_ID extends AggregateRootId, ENTITY_ID extends EntityId, TYPE extends AbstractAggregateCommand<ROOT_ID, ENTITY_ID>, BUILDER extends AbstractCommand.Builder<ROOT_ID, TYPE, BUILDER>>
    extends AbstractCommand.Builder<ROOT_ID, TYPE, BUILDER> {
        private AbstractAggregateCommand<ROOT_ID, ENTITY_ID> delegate;

        public Builder(TYPE delegate) {
            super(delegate);
            this.delegate = delegate;
        }

        public final BUILDER entityIdPath(@NotNull EntityIdPath entityIdPath) {
            Contract.requireArgNotNull((String)"entityIdPath", (Object)entityIdPath);
            this.delegate.entityIdPath = entityIdPath;
            return (BUILDER)((Object)this);
        }

        public final BUILDER entityIdPath(@NotNull AggregateRootId id) {
            Contract.requireArgNotNull((String)"id", (Object)id);
            this.delegate.entityIdPath = new EntityIdPath(new EntityId[]{id});
            return (BUILDER)((Object)this);
        }

        public final BUILDER aggregateVersion(@Nullable AggregateVersion aggregateVersion) {
            this.delegate.aggregateVersion = aggregateVersion;
            return (BUILDER)((Object)this);
        }

        protected final void ensureBuildableAbstractAggregateCommand() {
            this.ensureBuildableAbstractCommand();
            this.ensureNotNull("entityIdPath", this.delegate.entityIdPath);
        }

        protected final void resetAbstractAggregateCommand(TYPE delegate) {
            this.resetAbstractCommand(delegate);
            this.delegate = delegate;
        }
    }
}

