/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.cqrs4j;

import jakarta.validation.constraints.NotEmpty;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.fuin.cqrs4j.Command;
import org.fuin.cqrs4j.CommandExecutionFailedException;
import org.fuin.cqrs4j.CommandExecutor;
import org.fuin.ddd4j.ddd.AggregateAlreadyExistsException;
import org.fuin.ddd4j.ddd.AggregateDeletedException;
import org.fuin.ddd4j.ddd.AggregateNotFoundException;
import org.fuin.ddd4j.ddd.AggregateVersionConflictException;
import org.fuin.ddd4j.ddd.AggregateVersionNotFoundException;
import org.fuin.ddd4j.ddd.EventType;
import org.fuin.objects4j.common.ConstraintViolationException;
import org.fuin.objects4j.common.Contract;

public abstract class AbstractMultiCommandExecutor<CONTEXT, RESULT>
implements CommandExecutor<CONTEXT, RESULT, Command> {
    private final Map<EventType, CommandExecutor> commandExecutors;

    public AbstractMultiCommandExecutor(CommandExecutor ... cmdExecutors) {
        this(Arrays.asList(cmdExecutors));
    }

    public AbstractMultiCommandExecutor(@NotEmpty List<CommandExecutor> cmdExecutors) {
        Contract.requireArgNotNull((String)"cmdExecutors", cmdExecutors);
        if (cmdExecutors.isEmpty()) {
            throw new ConstraintViolationException("The argument 'cmdExecutors' cannot be an empty list");
        }
        this.commandExecutors = new HashMap<EventType, CommandExecutor>();
        for (CommandExecutor cmdExecutor : cmdExecutors) {
            if (cmdExecutor == null) {
                throw new ConstraintViolationException("Null is not allowed in the list of 'cmdExecutors': " + cmdExecutors);
            }
            Set<EventType> cmdTypes = cmdExecutor.getCommandTypes();
            for (EventType cmdType : cmdTypes) {
                if (this.commandExecutors.containsKey(cmdType)) {
                    throw new ConstraintViolationException("The argument 'cmdExecutors' contains multiple executors for command: " + cmdType);
                }
                this.commandExecutors.put(cmdType, cmdExecutor);
            }
        }
    }

    @Override
    public final Set<EventType> getCommandTypes() {
        return this.commandExecutors.keySet();
    }

    @Override
    public final RESULT execute(CONTEXT ctx, Command cmd) throws AggregateVersionConflictException, AggregateNotFoundException, AggregateVersionNotFoundException, AggregateDeletedException, AggregateAlreadyExistsException, CommandExecutionFailedException {
        Contract.requireArgNotNull((String)"ctx", ctx);
        Contract.requireArgNotNull((String)"cmd", (Object)cmd);
        CommandExecutor cmdExecutor = this.commandExecutors.get(cmd.getEventType());
        if (cmdExecutor == null) {
            throw new IllegalArgumentException("No executor found for command: " + cmd.getEventType());
        }
        return cmdExecutor.execute(ctx, cmd);
    }
}

