/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.cqrs4j;

import jakarta.json.bind.annotation.JsonbProperty;
import jakarta.validation.constraints.NotNull;
import jakarta.xml.bind.annotation.XmlElement;
import java.io.Serializable;
import org.fuin.cqrs4j.Result;
import org.fuin.cqrs4j.ResultType;
import org.fuin.objects4j.common.Contract;
import org.fuin.objects4j.common.ExceptionShortIdentifable;
import org.fuin.objects4j.common.Nullable;
import org.fuin.objects4j.ui.Label;
import org.fuin.objects4j.ui.Prompt;
import org.fuin.objects4j.ui.ShortLabel;
import org.fuin.objects4j.ui.Tooltip;

public abstract class AbstractResult<DATA>
implements Result<DATA>,
Serializable {
    private static final long serialVersionUID = 1000L;
    static final String TYPE_PROPERTY = "type";
    static final String CODE_PROPERTY = "code";
    static final String MESSAGE_PROPERTY = "message";
    @Label(value="Result Type")
    @ShortLabel(value="TYPE")
    @Tooltip(value="Type of the result")
    @Prompt(value="ERROR")
    @NotNull
    @JsonbProperty(value="type")
    @XmlElement(name="type")
    private ResultType type;
    @Label(value="Result Code")
    @ShortLabel(value="CODE")
    @Tooltip(value="Code that uniquely identifies the result. Mostly used in case of warnings or errors.")
    @Prompt(value="E00001")
    @Nullable
    @JsonbProperty(value="code")
    @XmlElement(name="code")
    private String code;
    @Label(value="Result Message")
    @ShortLabel(value="MSG")
    @Tooltip(value="Message that describes the result. Mostly used in case of warnings or errors.")
    @Prompt(value="The field 'Xyz' is mandatory")
    @Nullable
    @JsonbProperty(value="message")
    @XmlElement(name="message")
    private String message;

    protected AbstractResult() {
    }

    public AbstractResult(@NotNull ResultType type, @Nullable String code, @Nullable String message) {
        Contract.requireArgNotNull((String)TYPE_PROPERTY, (Object)((Object)type));
        this.type = type;
        this.code = code;
        this.message = message;
    }

    public AbstractResult(@NotNull Exception exception) {
        Contract.requireArgNotNull((String)"exception", (Object)exception);
        this.type = ResultType.ERROR;
        this.code = exception instanceof ExceptionShortIdentifable ? ((ExceptionShortIdentifable)exception).getShortId() : exception.getClass().getName();
        this.message = exception.getMessage() == null ? "" : exception.getMessage();
    }

    @Override
    public final ResultType getType() {
        return this.type;
    }

    @Override
    public final String getCode() {
        return this.code;
    }

    @Override
    public final String getMessage() {
        return this.message;
    }
}

