/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.cqrs4j;

import jakarta.json.Json;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonReader;
import jakarta.json.JsonStructure;
import jakarta.json.JsonValue;
import jakarta.json.JsonWriter;
import jakarta.json.bind.Jsonb;
import jakarta.json.bind.adapter.JsonbAdapter;
import jakarta.validation.constraints.NotNull;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import org.fuin.cqrs4j.DataResult;
import org.fuin.cqrs4j.ResultType;
import org.fuin.objects4j.common.Contract;

public final class DataResultJsonbAdapter
implements JsonbAdapter<DataResult, JsonObject> {
    private final Jsonb jsonb;

    public DataResultJsonbAdapter(@NotNull Jsonb jsonb) {
        Contract.requireArgNotNull((String)"jsonb", (Object)jsonb);
        this.jsonb = jsonb;
    }

    public JsonObject adaptToJson(DataResult result) throws Exception {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        builder.add("type", result.getType().name());
        if (result.getCode() != null) {
            builder.add("code", result.getCode());
        }
        if (result.getMessage() != null) {
            builder.add("message", result.getMessage());
        }
        if (result.getData() != null) {
            builder.add("data-class", result.getData().getClass().getName());
            String json = this.jsonb.toJson(result.getData());
            String elName = result.getDataElement();
            if (elName == null) {
                throw new IllegalStateException("The 'dataElementName' was empty, but is required fro JSON-B: " + result);
            }
            builder.add("data-element", result.getDataElement());
            builder.add(elName, (JsonValue)this.unmarshal(json));
        }
        return builder.build();
    }

    public DataResult adaptFromJson(JsonObject jsonObj) throws Exception {
        ResultType type = ResultType.valueOf(jsonObj.getString("type"));
        String code = this.getString(jsonObj, "code");
        String message = this.getString(jsonObj, "message");
        if (jsonObj.containsKey((Object)"data-class")) {
            if (!jsonObj.containsKey((Object)"data-element")) {
                throw new IllegalStateException("The 'data-element' was not found, but is required fro JSON-B: " + jsonObj);
            }
            Class<?> dataClass = Class.forName(jsonObj.getString("data-class"));
            String dataElement = this.getString(jsonObj, "data-element");
            JsonObject data = jsonObj.getJsonObject(dataElement);
            String json = this.marshal(data);
            Object obj = this.jsonb.fromJson(json, dataClass);
            return new DataResult<Object>(type, code, message, obj, dataElement);
        }
        return new DataResult<Object>(type, code, message, null);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private String marshal(JsonObject jsonObj) {
        try (StringWriter sw = new StringWriter();){
            String string;
            block13: {
                JsonWriter writer = Json.createWriter((Writer)sw);
                try {
                    writer.write((JsonStructure)jsonObj);
                    string = sw.toString();
                    if (writer == null) break block13;
                }
                catch (Throwable throwable) {
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                writer.close();
            }
            return string;
        }
        catch (IOException ex) {
            throw new RuntimeException("Failed to marshal JSON object to string: " + jsonObj, ex);
        }
    }

    private JsonObject unmarshal(String json) {
        try (JsonReader reader = Json.createReader((Reader)new StringReader(json));){
            JsonObject jsonObject = reader.readObject();
            return jsonObject;
        }
    }

    private String getString(JsonObject jsonObj, String name) {
        if (jsonObj.containsKey((Object)name)) {
            return jsonObj.getString(name);
        }
        return null;
    }
}

