/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.cqrs4j;

import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.fuin.cqrs4j.EventDispatcher;
import org.fuin.cqrs4j.EventHandler;
import org.fuin.ddd4j.ddd.Event;
import org.fuin.ddd4j.ddd.EventType;
import org.fuin.esc.api.CommonEvent;
import org.fuin.objects4j.common.Contract;

public final class SimpleEventDispatcher
implements EventDispatcher {
    private final Map<EventType, List<EventHandler>> eventHandlers;

    public SimpleEventDispatcher(EventHandler ... eventHandlers) {
        this(Arrays.asList(eventHandlers));
    }

    public SimpleEventDispatcher(@NotNull List<EventHandler> eventHandlers) {
        Contract.requireArgNotNull((String)"eventHandlers", eventHandlers);
        if (eventHandlers.isEmpty()) {
            throw new IllegalArgumentException("The argument 'eventHandlers' cannot be an empty list");
        }
        this.eventHandlers = new HashMap<EventType, List<EventHandler>>();
        for (EventHandler eventHandler : eventHandlers) {
            List<EventHandler> handlers = this.eventHandlers.get(eventHandler.getEventType());
            if (handlers == null) {
                handlers = new ArrayList<EventHandler>();
                this.eventHandlers.put(eventHandler.getEventType(), handlers);
            }
            handlers.add(eventHandler);
        }
    }

    @Override
    @NotNull
    public final Set<EventType> getAllTypes() {
        return this.eventHandlers.keySet();
    }

    @Override
    public final void dispatchCommonEvents(@NotNull List<CommonEvent> commonEvents) {
        Contract.requireArgNotNull((String)"commonEvents", commonEvents);
        for (CommonEvent commonEvent : commonEvents) {
            Event event = (Event)commonEvent.getData();
            this.dispatchEvent(event);
        }
    }

    @Override
    public final void dispatchEvents(@NotNull List<Event> events) {
        Contract.requireArgNotNull((String)"events", events);
        for (Event event : events) {
            this.dispatchEvent(event);
        }
    }

    @Override
    public final void dispatchEvent(@NotNull Event event) {
        Contract.requireArgNotNull((String)"event", (Object)event);
        List<EventHandler> handlers = this.eventHandlers.get(event.getEventType());
        if (handlers != null) {
            for (EventHandler handler : handlers) {
                handler.handle(event);
            }
        }
    }
}

