/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.ddd4j.ddd;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.fuin.ddd4j.ddd.EntityId;
import org.fuin.ddd4j.ddd.EntityIdPathConverter;
import org.fuin.objects4j.common.ConstraintViolationException;
import org.fuin.objects4j.common.Contract;
import org.fuin.objects4j.ui.Label;
import org.fuin.objects4j.ui.Prompt;
import org.fuin.objects4j.ui.ShortLabel;
import org.fuin.objects4j.ui.Tooltip;
import org.fuin.objects4j.vo.AbstractStringValueObject;

@Label(value="Entity identifier path")
@ShortLabel(value="EntityIdPath")
@Tooltip(value="An ordered list of entity identifiers that is separated by '/'. An aggregate root will be the first entry if it's contained in the list.")
@Prompt(value="Customer deb2317d-5b3a-4d56-a9df-689f4c4ff982/Person 123")
@XmlJavaTypeAdapter(value=EntityIdPathConverter.class)
public final class EntityIdPath
extends AbstractStringValueObject
implements Serializable {
    private static final long serialVersionUID = 1000L;
    public static final String PATH_SEPARATOR = "/";
    private final List<EntityId> entityIds;

    public EntityIdPath(EntityId ... entityIds) {
        Contract.requireArgNotNull((String)"entityIds", (Object)entityIds);
        if (entityIds.length == 0) {
            throw new ConstraintViolationException("Identifier array cannot be empty");
        }
        for (EntityId entityId : entityIds) {
            if (entityId != null) continue;
            throw new ConstraintViolationException("Identifiers in the array cannot be null");
        }
        this.entityIds = new ArrayList<EntityId>();
        this.entityIds.addAll(Arrays.asList(entityIds));
    }

    public EntityIdPath(List<EntityId> ids) {
        Contract.requireArgNotNull((String)"ids", ids);
        if (ids.size() == 0) {
            throw new ConstraintViolationException("Identifier list cannot be empty");
        }
        for (EntityId entityId : ids) {
            if (entityId != null) continue;
            throw new ConstraintViolationException("Identifiers in the list cannot be null");
        }
        this.entityIds = new ArrayList<EntityId>();
        this.entityIds.addAll(ids);
    }

    public final Iterator<EntityId> iterator() {
        return new ArrayList<EntityId>(this.entityIds).iterator();
    }

    public final <T extends EntityId> T first() {
        return (T)this.entityIds.get(0);
    }

    public final <T extends EntityId> T last() {
        return (T)this.entityIds.get(this.entityIds.size() - 1);
    }

    public final EntityIdPath rest() {
        if (this.entityIds.size() == 1) {
            return null;
        }
        ArrayList<EntityId> list = new ArrayList<EntityId>();
        for (int i = 1; i < this.entityIds.size(); ++i) {
            list.add(this.entityIds.get(i));
        }
        return new EntityIdPath(list);
    }

    public EntityIdPath parent() {
        if (this.entityIds.size() == 1) {
            return null;
        }
        ArrayList<EntityId> list = new ArrayList<EntityId>();
        for (int i = 0; i < this.entityIds.size() - 1; ++i) {
            list.add(this.entityIds.get(i));
        }
        return new EntityIdPath(list);
    }

    public final int size() {
        return this.entityIds.size();
    }

    public final String asBaseType() {
        StringBuilder sb = new StringBuilder();
        for (EntityId entityId : this.entityIds) {
            if (sb.length() > 0) {
                sb.append(PATH_SEPARATOR);
            }
            sb.append(entityId.asTypedString());
        }
        return sb.toString();
    }

    public final String toString() {
        return this.asBaseType();
    }
}

