/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.ddd4j.esrepo;

import java.util.ArrayList;
import java.util.List;
import javax.validation.constraints.NotNull;
import org.fuin.ddd4j.ddd.AggregateAlreadyExistsException;
import org.fuin.ddd4j.ddd.AggregateCache;
import org.fuin.ddd4j.ddd.AggregateDeletedException;
import org.fuin.ddd4j.ddd.AggregateNoCache;
import org.fuin.ddd4j.ddd.AggregateNotFoundException;
import org.fuin.ddd4j.ddd.AggregateRoot;
import org.fuin.ddd4j.ddd.AggregateRootId;
import org.fuin.ddd4j.ddd.AggregateVersionConflictException;
import org.fuin.ddd4j.ddd.AggregateVersionNotFoundException;
import org.fuin.ddd4j.ddd.DomainEvent;
import org.fuin.ddd4j.ddd.Repository;
import org.fuin.ddd4j.esrepo.AggregateStreamId;
import org.fuin.esc.api.CommonEvent;
import org.fuin.esc.api.EventId;
import org.fuin.esc.api.EventStore;
import org.fuin.esc.api.ExpectedVersion;
import org.fuin.esc.api.SimpleCommonEvent;
import org.fuin.esc.api.StreamDeletedException;
import org.fuin.esc.api.StreamEventsSlice;
import org.fuin.esc.api.StreamId;
import org.fuin.esc.api.StreamNotFoundException;
import org.fuin.esc.api.TypeName;
import org.fuin.esc.api.WrongExpectedVersionException;
import org.fuin.objects4j.common.Contract;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EventStoreRepository<ID extends AggregateRootId, AGGREGATE extends AggregateRoot<ID>>
implements Repository<ID, AGGREGATE> {
    private static final String MAX_AGGREGATE_VERSION_EXCEEDED = "Exceeded maximum number of aggregate versions. The Event Store operates with 'long' versions but aggregates only can handle 'int' versions.";
    private static final Logger LOG = LoggerFactory.getLogger(EventStoreRepository.class);
    private final EventStore eventStore;
    private final AggregateCache<AGGREGATE> noCache;

    protected EventStoreRepository(@NotNull EventStore eventStore) {
        Contract.requireArgNotNull((String)"eventStore", (Object)eventStore);
        this.eventStore = eventStore;
        this.noCache = new AggregateNoCache();
    }

    @Override
    public final AGGREGATE read(ID aggregateId) throws AggregateNotFoundException, AggregateDeletedException {
        Contract.requireArgNotNull((String)"aggregateId", aggregateId);
        try {
            AggregateRoot<Object> aggregate = (AggregateRoot)this.getAggregateCache().get((AggregateRootId)aggregateId, null);
            if (aggregate == null) {
                LOG.debug("Aggregate {} not found in cache", (Object)aggregateId.asTypedString());
                aggregate = this.create();
            }
            return (AGGREGATE)this.read(aggregate, aggregateId, Integer.MAX_VALUE);
        }
        catch (AggregateVersionNotFoundException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public final AGGREGATE read(ID aggregateId, int version) throws AggregateNotFoundException, AggregateDeletedException, AggregateVersionNotFoundException {
        Contract.requireArgNotNull((String)"aggregateId", aggregateId);
        AggregateRoot<Object> aggregate = (AggregateRoot)this.getAggregateCache().get((AggregateRootId)aggregateId, version);
        if (aggregate == null) {
            LOG.debug("Aggregate {} not found in cache", (Object)aggregateId.asTypedString());
            aggregate = this.create();
        } else if (aggregate.getVersion() > version) {
            LOG.debug("Aggregate {} found in cache - Requested version {}, but found: {}", new Object[]{aggregateId.asTypedString(), version, aggregate.getVersion()});
            aggregate = this.create();
        } else if (aggregate.getVersion() == version) {
            LOG.debug("Aggregate {} found in cache with requested version: {}", (Object)aggregateId.asTypedString(), (Object)version);
            return (AGGREGATE)aggregate;
        }
        return (AGGREGATE)this.read(aggregate, aggregateId, version);
    }

    private AGGREGATE read(AGGREGATE aggregate, ID id, int targetAggregateVersion) throws AggregateNotFoundException, AggregateDeletedException, AggregateVersionNotFoundException {
        StreamEventsSlice currentSlice;
        this.requireNoUncommittedChanges(aggregate);
        LOG.info("Read aggregate: id={}, targetVersion={}", (Object)id.asTypedString(), (Object)targetAggregateVersion);
        AggregateStreamId streamId = new AggregateStreamId(this.getAggregateType(), this.getIdParamName(), (AggregateRootId)id);
        int readPageSize = this.getReadPageSize();
        int sliceStart = aggregate.getVersion() + 1;
        do {
            int sliceCount = readPageSize <= targetAggregateVersion ? readPageSize : targetAggregateVersion - sliceStart + 1;
            try {
                LOG.debug("Read slice: streamId={}, sliceStart={}, sliceCount={}", new Object[]{streamId, sliceStart, sliceCount});
                currentSlice = this.getEventStore().readEventsForward((StreamId)streamId, (long)sliceStart, sliceCount);
                LOG.debug("Result slice: {}", (Object)currentSlice);
            }
            catch (StreamNotFoundException ex) {
                throw new AggregateNotFoundException(this.getAggregateType(), (AggregateRootId)id);
            }
            catch (StreamDeletedException ex) {
                throw new AggregateDeletedException(this.getAggregateType(), (AggregateRootId)id);
            }
            for (CommonEvent commonEvent : currentSlice.getEvents()) {
                DomainEvent event = (DomainEvent)commonEvent.getData();
                aggregate.loadFromHistory(event);
            }
            sliceStart = this.intVersion(currentSlice.getNextEventNumber());
        } while (aggregate.getVersion() != targetAggregateVersion && !currentSlice.isEndOfStream());
        if (aggregate.getVersion() != targetAggregateVersion && targetAggregateVersion < Integer.MAX_VALUE) {
            throw new AggregateVersionNotFoundException(this.getAggregateType(), (AggregateRootId)id, targetAggregateVersion);
        }
        this.getAggregateCache().put((AggregateRootId)aggregate.getId(), aggregate);
        return aggregate;
    }

    private void requireNoUncommittedChanges(AGGREGATE aggregate) {
        if (aggregate.hasUncommitedChanges()) {
            throw new IllegalArgumentException("The aggregate '" + this.getAggregateType() + "' (" + (AggregateRootId)aggregate.getId() + ") has uncommitted changes");
        }
    }

    @Override
    public final void update(AGGREGATE aggregate) throws AggregateVersionConflictException, AggregateNotFoundException, AggregateDeletedException {
        this.update(aggregate, (String)null, (Object)null);
    }

    @Override
    public final void update(AGGREGATE aggregate, String metaType, Object metaData) throws AggregateVersionConflictException, AggregateNotFoundException, AggregateDeletedException {
        Contract.requireArgNotNull((String)"aggregate", aggregate);
        LOG.info("Update aggregate: id={}, version={}, nextVersion={}", new Object[]{aggregate.getId().asTypedString(), aggregate.getVersion(), aggregate.getNextVersion()});
        AggregateStreamId streamId = new AggregateStreamId(this.getAggregateType(), this.getIdParamName(), (AggregateRootId)aggregate.getId());
        List<DomainEvent<?>> events = aggregate.getUncommittedChanges();
        List<CommonEvent> eventDataList = this.asCommonEvents(events, metaType, metaData);
        long expectedVersion = this.expectedVersion(aggregate);
        int retryCount = 0;
        boolean unsaved = true;
        do {
            try {
                int eventStoreNextVersion = this.intVersion(this.getEventStore().appendToStream((StreamId)streamId, expectedVersion, eventDataList));
                if (expectedVersion + (long)eventDataList.size() != (long)eventStoreNextVersion) {
                    throw new IllegalStateException("Aggregate next version is " + aggregate.getNextVersion() + " but event store's is " + eventStoreNextVersion);
                }
                aggregate.markChangesAsCommitted();
                unsaved = false;
            }
            catch (WrongExpectedVersionException ex) {
                LOG.debug("Version conflict: id={}, expected={}, actual={}, retryCount={}", new Object[]{aggregate.getId().asTypedString(), ex.getExpected(), ex.getActual(), retryCount});
                expectedVersion = this.resolveConflicts(aggregate, this.integerVersion(ex.getActual()), retryCount++);
            }
            catch (StreamDeletedException | StreamNotFoundException ex) {
                throw new AggregateNotFoundException(this.getAggregateType(), (AggregateRootId)aggregate.getId());
            }
        } while (unsaved);
    }

    @Override
    public void add(AGGREGATE aggregate) throws AggregateAlreadyExistsException, AggregateDeletedException {
        this.add(aggregate, (String)null, (Object)null);
    }

    @Override
    public void add(AGGREGATE aggregate, String metaType, Object metaData) throws AggregateAlreadyExistsException, AggregateDeletedException {
        try {
            this.update(aggregate, metaType, metaData);
        }
        catch (AggregateVersionConflictException ex) {
            throw new AggregateAlreadyExistsException(this.getAggregateType(), (AggregateRootId)aggregate.getId(), ex.getActual());
        }
        catch (AggregateNotFoundException ex) {
            throw new IllegalStateException(ex);
        }
    }

    private int expectedVersion(AGGREGATE aggregate) {
        if (aggregate.getVersion() == -1) {
            return this.intVersion(ExpectedVersion.NO_OR_EMPTY_STREAM.getNo());
        }
        return aggregate.getVersion();
    }

    private int resolveConflicts(AGGREGATE aggregate, Integer actualVersion, int retryCount) throws AggregateVersionConflictException, AggregateNotFoundException, AggregateDeletedException {
        int latestVersion = actualVersion == null || actualVersion < 0 ? this.read(aggregate.getId()).getVersion() : actualVersion.intValue();
        if (retryCount == this.getMaxTryCount()) {
            throw new AggregateVersionConflictException(this.getAggregateType(), (AggregateRootId)aggregate.getId(), aggregate.getVersion(), latestVersion);
        }
        List<DomainEvent<?>> unseenEvents = this.readEvents(aggregate.getId(), aggregate.getVersion() + 1);
        if (this.conflictsResolved(aggregate.getUncommittedChanges(), unseenEvents)) {
            return latestVersion;
        }
        throw new AggregateVersionConflictException(this.getAggregateType(), (AggregateRootId)aggregate.getId(), aggregate.getVersion(), latestVersion);
    }

    @Override
    public final void delete(ID aggregateId, int expectedVersion) throws AggregateVersionConflictException {
        Contract.requireArgNotNull((String)"aggregateId", aggregateId);
        LOG.info("Delete aggregate: id={}, expectedVersion={}", (Object)aggregateId.asTypedString(), (Object)expectedVersion);
        try {
            AggregateStreamId streamId = new AggregateStreamId(this.getAggregateType(), this.getIdParamName(), (AggregateRootId)aggregateId);
            this.getEventStore().deleteStream((StreamId)streamId, (long)expectedVersion, false);
        }
        catch (WrongExpectedVersionException ex) {
            throw new AggregateVersionConflictException(this.getAggregateType(), (AggregateRootId)aggregateId, this.integerVersion(ex.getExpected()), this.integerVersion(ex.getActual()));
        }
        catch (StreamDeletedException ex) {
            LOG.debug("Aggregate {} was already deleted: {}", aggregateId, (Object)ex.getMessage());
        }
    }

    private List<DomainEvent<?>> readEvents(ID aggregateId, int startVersion) throws AggregateNotFoundException, AggregateDeletedException {
        StreamEventsSlice currentSlice;
        LOG.info("Read events: id={}, startVersion={}", (Object)aggregateId.asTypedString(), (Object)startVersion);
        ArrayList list = new ArrayList();
        AggregateStreamId streamId = new AggregateStreamId(this.getAggregateType(), this.getIdParamName(), (AggregateRootId)aggregateId);
        int sliceCount = this.getReadPageSize();
        int sliceStart = startVersion;
        do {
            try {
                LOG.debug("Read slice: streamId={}, sliceStart={}, sliceCount={}", new Object[]{streamId, sliceStart, sliceCount});
                currentSlice = this.getEventStore().readEventsForward((StreamId)streamId, (long)sliceStart, sliceCount);
                LOG.debug("Result slice: {}", (Object)currentSlice);
            }
            catch (StreamNotFoundException ex) {
                throw new AggregateNotFoundException(this.getAggregateType(), (AggregateRootId)aggregateId);
            }
            catch (StreamDeletedException ex) {
                throw new AggregateDeletedException(this.getAggregateType(), (AggregateRootId)aggregateId);
            }
            for (CommonEvent commonEvent : currentSlice.getEvents()) {
                DomainEvent event = (DomainEvent)commonEvent.getData();
                list.add(event);
            }
            sliceStart = this.intVersion(currentSlice.getNextEventNumber());
        } while (!currentSlice.isEndOfStream());
        return list;
    }

    private List<CommonEvent> asCommonEvents(List<DomainEvent<?>> events, String metaType, Object metaData) {
        ArrayList<CommonEvent> list = new ArrayList<CommonEvent>();
        for (DomainEvent<?> event : events) {
            SimpleCommonEvent sce;
            if (metaData == null) {
                sce = new SimpleCommonEvent(new EventId(event.getEventId().asBaseType()), new TypeName(event.getEventType().asBaseType()), event);
            } else {
                if (metaType == null) {
                    throw new IllegalArgumentException("Argument 'metaType' cannot be null if 'metaData' is provided (non-null)");
                }
                sce = new SimpleCommonEvent(new EventId(event.getEventId().asBaseType()), new TypeName(event.getEventType().asBaseType()), event, new TypeName(metaType), metaData);
            }
            list.add((CommonEvent)sce);
        }
        return list;
    }

    private int intVersion(long version) {
        if (version > Integer.MAX_VALUE) {
            throw new IllegalStateException(MAX_AGGREGATE_VERSION_EXCEEDED);
        }
        return (int)version;
    }

    private Integer integerVersion(Long version) {
        if (version == null) {
            return null;
        }
        if (version > Integer.MAX_VALUE) {
            throw new IllegalStateException(MAX_AGGREGATE_VERSION_EXCEEDED);
        }
        return version.intValue();
    }

    protected boolean conflictsResolved(List<DomainEvent<?>> uncommittedChanges, List<DomainEvent<?>> unseenEvents) {
        return false;
    }

    protected int getMaxTryCount() {
        return 3;
    }

    @NotNull
    protected AggregateCache<AGGREGATE> getAggregateCache() {
        return this.noCache;
    }

    public int getReadPageSize() {
        return 100;
    }

    @NotNull
    protected final EventStore getEventStore() {
        return this.eventStore;
    }

    @NotNull
    protected abstract String getIdParamName();
}

