/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.ddd4j.ddd;

import jakarta.validation.constraints.NotNull;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.fuin.ddd4j.ddd.AbstractEntity;
import org.fuin.ddd4j.ddd.AggregateRoot;
import org.fuin.ddd4j.ddd.AggregateRootId;
import org.fuin.ddd4j.ddd.AggregateVersion;
import org.fuin.ddd4j.ddd.ApplyEvent;
import org.fuin.ddd4j.ddd.ChildEntityLocator;
import org.fuin.ddd4j.ddd.DomainEvent;
import org.fuin.ddd4j.ddd.Entity;
import org.fuin.ddd4j.ddd.EntityId;
import org.fuin.ddd4j.ddd.EntityIdPath;
import org.fuin.ddd4j.ddd.MethodExecutor;
import org.fuin.objects4j.common.Contract;

public abstract class AbstractAggregateRoot<ID extends AggregateRootId>
implements AggregateRoot<ID> {
    private static final MethodExecutor METHOD_EXECUTOR = new MethodExecutor();
    private int version = -1;
    private final List<DomainEvent<?>> uncommitedChanges = new ArrayList();

    public final int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.getId().hashCode();
        return result;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractAggregateRoot other = (AbstractAggregateRoot)obj;
        return this.getId().equals(other.getId());
    }

    @Override
    public final List<DomainEvent<?>> getUncommittedChanges() {
        return Collections.unmodifiableList(this.uncommitedChanges);
    }

    @Override
    public final boolean hasUncommitedChanges() {
        return this.uncommitedChanges.size() > 0;
    }

    @Override
    public final void markChangesAsCommitted() {
        this.version = this.getNextVersion();
        this.uncommitedChanges.clear();
    }

    @Override
    public final int getVersion() {
        return this.version;
    }

    @Override
    public final int getNextVersion() {
        return this.version + this.uncommitedChanges.size();
    }

    @Override
    public final AggregateVersion getNextApplyVersion() {
        return AggregateVersion.valueOf(this.getNextVersion() + 1);
    }

    @Override
    public final void loadFromHistory(DomainEvent<?> ... history) {
        if (history == null) {
            return;
        }
        this.loadFromHistory(Arrays.asList(history));
    }

    @Override
    public final void loadFromHistory(List<DomainEvent<?>> history) {
        if (history == null) {
            return;
        }
        for (DomainEvent<?> event : history) {
            if (this.getIgnoredEvents().contains(event.getClass())) continue;
            boolean applied = AbstractAggregateRoot.callAnnotatedEventHandlerMethodOnAggregateRootOrChild(this, event);
            if (applied) {
                ++this.version;
                continue;
            }
            throw new IllegalStateException("Wasn't able to apply historic event '" + event + "' to: " + this.getClass().getName());
        }
    }

    static boolean callAnnotatedEventHandlerMethodOnAggregateRootOrChild(AggregateRoot<?> aggregateRoot, DomainEvent<?> event) {
        EntityIdPath path = event.getEntityIdPath();
        Iterator<EntityId> idIt = path.iterator();
        EntityId entityId = idIt.next();
        if (!(entityId instanceof AggregateRootId)) {
            throw new IllegalStateException("The first ID in the entity identifier path was not an " + AggregateRootId.class.getSimpleName() + ": " + path);
        }
        if (!idIt.hasNext()) {
            return AbstractAggregateRoot.callAnnotatedEventHandlerMethod(aggregateRoot, event);
        }
        Entity<Object> entity = aggregateRoot;
        while (idIt.hasNext()) {
            EntityId id = idIt.next();
            Method foundChildEntityMethod = METHOD_EXECUTOR.findDeclaredAnnotatedMethod(entity, ChildEntityLocator.class, id.getClass());
            if (foundChildEntityMethod == null) {
                return false;
            }
            entity = (Entity)METHOD_EXECUTOR.invoke(foundChildEntityMethod, entity, id);
        }
        return AbstractAggregateRoot.callAnnotatedEventHandlerMethod(entity, event);
    }

    protected final List<Class<? extends DomainEvent<?>>> getIgnoredEvents() {
        return Collections.emptyList();
    }

    protected final void apply(@NotNull DomainEvent<?> event) {
        if (!AbstractAggregateRoot.callAnnotatedEventHandlerMethod(this, event)) {
            throw new IllegalStateException("Couldn't find an event handler for: " + event.getClass().getName());
        }
        this.uncommitedChanges.add(event);
    }

    final void applyNewChildEvent(@NotNull AbstractEntity<?, ?, ?> entity, @NotNull DomainEvent<?> event) {
        if (!AbstractAggregateRoot.callAnnotatedEventHandlerMethod(entity, event)) {
            throw new IllegalStateException("Couldn't find an event handler in '" + entity.getClass().getName() + "' for: " + event);
        }
        this.uncommitedChanges.add(event);
    }

    static boolean callAnnotatedEventHandlerMethod(Entity<?> entity, DomainEvent<?> event) {
        Contract.requireArgNotNull((String)"entity", entity);
        Contract.requireArgNotNull((String)"event", event);
        Method method = METHOD_EXECUTOR.findDeclaredAnnotatedMethod(entity, ApplyEvent.class, event.getClass());
        if (method == null) {
            return false;
        }
        METHOD_EXECUTOR.invoke(method, entity, event);
        return true;
    }
}

