/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.ddd4j.ddd;

import jakarta.json.bind.annotation.JsonbProperty;
import jakarta.validation.constraints.NotNull;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.Serializable;
import org.fuin.ddd4j.ddd.AggregateRootId;
import org.fuin.ddd4j.ddd.EntityType;
import org.fuin.objects4j.common.Contract;
import org.fuin.objects4j.common.ExceptionShortIdentifable;
import org.fuin.objects4j.common.MarshalInformation;
import org.fuin.objects4j.common.ToExceptionCapable;
import org.fuin.objects4j.vo.ValueObject;

public final class AggregateAlreadyExistsException
extends Exception
implements ExceptionShortIdentifable,
MarshalInformation<Data> {
    private static final long serialVersionUID = 1L;
    public static final String SHORT_ID = "DDD4J-AGGREGATE_ALREADY_EXISTS";
    public static final String ELEMENT_NAME = "aggregate-already-exists-exception";
    private final Data data;

    public AggregateAlreadyExistsException(@NotNull EntityType aggregateType, @NotNull AggregateRootId aggregateId, int version) {
        super(aggregateType.asString() + " " + aggregateId.asString() + " already exists (version=" + version + ")");
        Contract.requireArgNotNull((String)"aggregateType", (Object)aggregateType);
        Contract.requireArgNotNull((String)"aggregateId", (Object)aggregateId);
        this.data = new Data(this.getMessage(), SHORT_ID, aggregateType.asString(), aggregateId.asString(), version);
    }

    private AggregateAlreadyExistsException(Data data) {
        super(data.message);
        this.data = data;
    }

    public final String getShortId() {
        return this.data.sid;
    }

    @NotNull
    public final String getAggregateType() {
        return this.data.aggregateType;
    }

    @NotNull
    public final String getAggregateId() {
        return this.data.aggregateId;
    }

    public final int getVersion() {
        return this.data.version;
    }

    public final Data getData() {
        return this.data;
    }

    public Class<Data> getDataClass() {
        return Data.class;
    }

    public String getDataElement() {
        return ELEMENT_NAME;
    }

    @XmlRootElement(name="aggregate-already-exists-exception")
    @XmlAccessorType(value=XmlAccessType.NONE)
    public static final class Data
    implements Serializable,
    ValueObject,
    ToExceptionCapable<AggregateAlreadyExistsException> {
        private static final long serialVersionUID = 1000L;
        @JsonbProperty(value="msg")
        @XmlElement(name="msg")
        private String message;
        @JsonbProperty(value="sid")
        @XmlElement(name="sid")
        private String sid;
        @JsonbProperty(value="aggregate-type")
        @XmlElement(name="aggregate-type")
        private String aggregateType;
        @JsonbProperty(value="aggregate-id")
        @XmlElement(name="aggregate-id")
        private String aggregateId;
        @JsonbProperty(value="version")
        @XmlElement(name="version")
        private int version;

        protected Data() {
        }

        private Data(String message, String sid, String aggregateType, String aggregateId, int version) {
            this.message = message;
            this.sid = sid;
            this.aggregateType = aggregateType;
            this.aggregateId = aggregateId;
            this.version = version;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.aggregateId == null ? 0 : this.aggregateId.hashCode());
            result = 31 * result + (this.aggregateType == null ? 0 : this.aggregateType.hashCode());
            result = 31 * result + (this.message == null ? 0 : this.message.hashCode());
            result = 31 * result + (this.sid == null ? 0 : this.sid.hashCode());
            result = 31 * result + this.version;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Data other = (Data)obj;
            if (this.aggregateId == null ? other.aggregateId != null : !this.aggregateId.equals(other.aggregateId)) {
                return false;
            }
            if (this.aggregateType == null ? other.aggregateType != null : !this.aggregateType.equals(other.aggregateType)) {
                return false;
            }
            if (this.message == null ? other.message != null : !this.message.equals(other.message)) {
                return false;
            }
            if (this.sid == null ? other.sid != null : !this.sid.equals(other.sid)) {
                return false;
            }
            return this.version == other.version;
        }

        public String toString() {
            return "Data [message=" + this.message + ", sid=" + this.sid + ", aggregateType=" + this.aggregateType + ", aggregateId=" + this.aggregateId + ", version=" + this.version + "]";
        }

        public AggregateAlreadyExistsException toException() {
            return new AggregateAlreadyExistsException(this);
        }
    }
}

