/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.ddd4j.ddd;

import jakarta.json.bind.annotation.JsonbProperty;
import jakarta.validation.constraints.NotEmpty;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.Serializable;
import org.fuin.objects4j.common.ExceptionShortIdentifable;
import org.fuin.objects4j.common.MarshalInformation;
import org.fuin.objects4j.common.ToExceptionCapable;
import org.fuin.objects4j.vo.ValueObject;

public final class EncryptionKeyIdUnknownException
extends Exception
implements ExceptionShortIdentifable,
MarshalInformation<Data> {
    private static final long serialVersionUID = 1L;
    public static final String SHORT_ID = "DDD4J-ENCRYPTION_KEY_ID_UNKNOWN";
    public static final String ELEMENT_NAME = "encryption-key-id-unknown-exception";
    private final Data data;

    public EncryptionKeyIdUnknownException(@NotEmpty String keyId) {
        super("Unknown keyId: " + keyId);
        this.data = new Data(this.getMessage(), SHORT_ID, keyId);
    }

    private EncryptionKeyIdUnknownException(Data data) {
        super(data.message);
        this.data = data;
    }

    public final String getShortId() {
        return this.data.sid;
    }

    @NotEmpty
    public final String getKeyId() {
        return this.data.keyId;
    }

    public final Data getData() {
        return this.data;
    }

    public Class<Data> getDataClass() {
        return Data.class;
    }

    public String getDataElement() {
        return ELEMENT_NAME;
    }

    @XmlRootElement(name="encryption-key-id-unknown-exception")
    @XmlAccessorType(value=XmlAccessType.NONE)
    public static final class Data
    implements Serializable,
    ValueObject,
    ToExceptionCapable<EncryptionKeyIdUnknownException> {
        private static final long serialVersionUID = 1000L;
        @JsonbProperty(value="msg")
        @XmlElement(name="msg")
        private String message;
        @JsonbProperty(value="sid")
        @XmlElement(name="sid")
        private String sid;
        @JsonbProperty(value="key-id")
        @XmlElement(name="key-id")
        private String keyId;

        protected Data() {
        }

        private Data(String message, String sid, String keyId) {
            this.message = message;
            this.sid = sid;
            this.keyId = keyId;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.message == null ? 0 : this.message.hashCode());
            result = 31 * result + (this.sid == null ? 0 : this.sid.hashCode());
            result = 31 * result + (this.keyId == null ? 0 : this.keyId.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Data other = (Data)obj;
            if (this.message == null ? other.message != null : !this.message.equals(other.message)) {
                return false;
            }
            if (this.sid == null ? other.sid != null : !this.sid.equals(other.sid)) {
                return false;
            }
            return !(this.keyId == null ? other.keyId != null : !this.keyId.equals(other.keyId));
        }

        public String toString() {
            return "Data [message=" + this.message + ", sid=" + this.sid + ", keyId=" + this.keyId + "]";
        }

        public EncryptionKeyIdUnknownException toException() {
            return new EncryptionKeyIdUnknownException(this);
        }
    }
}

