/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.ddd4j.ddd;

import jakarta.persistence.AttributeConverter;
import jakarta.persistence.Converter;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.fuin.ddd4j.ddd.EntityId;
import org.fuin.ddd4j.ddd.EntityIdConverter;
import org.fuin.ddd4j.ddd.EntityIdFactory;
import org.fuin.ddd4j.ddd.EntityIdPath;
import org.fuin.objects4j.common.ConstraintViolationException;
import org.fuin.objects4j.common.ThreadSafe;
import org.fuin.objects4j.vo.AbstractValueObjectConverter;

@Converter(autoApply=true)
@ThreadSafe
public final class EntityIdPathConverter
extends AbstractValueObjectConverter<String, EntityIdPath>
implements AttributeConverter<EntityIdPath, String> {
    private final EntityIdConverter converter;

    public EntityIdPathConverter(EntityIdFactory factory) {
        if (factory == null) {
            throw new IllegalStateException("Factory cannot be null");
        }
        this.converter = new EntityIdConverter(factory);
    }

    public final Class<String> getBaseTypeClass() {
        return String.class;
    }

    public final Class<EntityIdPath> getValueObjectClass() {
        return EntityIdPath.class;
    }

    public final boolean isValid(String value) {
        if (value == null) {
            return true;
        }
        List<String> entryList = this.entries(value);
        if (entryList.isEmpty()) {
            return false;
        }
        for (String entry : entryList) {
            if (this.converter.isValid(entry)) continue;
            return false;
        }
        return true;
    }

    public final void requireArgValid(@NotNull String name, @NotNull String value) throws ConstraintViolationException {
        if (!this.isValid(value)) {
            throw new ConstraintViolationException("The argument '" + name + "' is not valid: '" + value + "'");
        }
    }

    public final EntityIdPath toVO(String value) {
        if (value == null) {
            return null;
        }
        List<String> entryList = this.entries(value);
        if (entryList.isEmpty()) {
            throw new IllegalArgumentException("Invalid entity path: '" + value + "'");
        }
        ArrayList<EntityId> ids = new ArrayList<EntityId>();
        for (String entry : entryList) {
            ids.add(this.converter.toVO(entry));
        }
        return new EntityIdPath(ids);
    }

    public final String fromVO(EntityIdPath value) {
        if (value == null) {
            return null;
        }
        return value.asString();
    }

    private List<String> entries(String value) {
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer tok = new StringTokenizer(value, "/");
        while (tok.hasMoreTokens()) {
            String str = tok.nextToken();
            list.add(str);
        }
        return list;
    }
}

