/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.ddd4j.jaxb;

import jakarta.annotation.Nullable;
import jakarta.validation.constraints.NotNull;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.fuin.ddd4j.core.AggregateRootId;
import org.fuin.ddd4j.core.AggregateVersion;
import org.fuin.ddd4j.core.DomainEvent;
import org.fuin.ddd4j.core.EntityId;
import org.fuin.ddd4j.core.EntityIdPath;
import org.fuin.ddd4j.core.Event;
import org.fuin.ddd4j.core.EventId;
import org.fuin.ddd4j.jaxb.AbstractEvent;
import org.fuin.ddd4j.jaxb.AggregateVersionXmlAdapter;
import org.fuin.ddd4j.jaxb.EntityIdPathXmlAdapter;
import org.fuin.objects4j.common.Contract;

public abstract class AbstractDomainEvent<ID extends EntityId>
extends AbstractEvent
implements DomainEvent<ID> {
    private static final long serialVersionUID = 1000L;
    @NotNull
    @XmlJavaTypeAdapter(value=EntityIdPathXmlAdapter.class)
    @XmlElement(name="entity-id-path")
    private EntityIdPath entityIdPath;
    @Nullable
    @XmlJavaTypeAdapter(value=AggregateVersionXmlAdapter.class)
    @XmlElement(name="aggregate-version")
    private AggregateVersion aggregateVersion;

    protected AbstractDomainEvent() {
    }

    public AbstractDomainEvent(@NotNull EntityIdPath entityIdPath) {
        this.entityIdPath = entityIdPath;
    }

    public AbstractDomainEvent(@NotNull EntityIdPath entityIdPath, @NotNull Event respondTo) {
        super(respondTo);
        this.entityIdPath = entityIdPath;
    }

    public AbstractDomainEvent(@NotNull EntityIdPath entityIdPath, @Nullable EventId correlationId, @Nullable EventId causationId) {
        super(correlationId, causationId);
        this.entityIdPath = entityIdPath;
    }

    public final EntityIdPath getEntityIdPath() {
        return this.entityIdPath;
    }

    public final ID getEntityId() {
        return (ID)this.entityIdPath.last();
    }

    @Nullable
    public final AggregateVersion getAggregateVersion() {
        return this.aggregateVersion;
    }

    @Nullable
    public final Integer getAggregateVersionInteger() {
        if (this.aggregateVersion == null) {
            return null;
        }
        return this.aggregateVersion.asBaseType();
    }

    protected static abstract class Builder<ID extends EntityId, TYPE extends AbstractDomainEvent<ID>, BUILDER extends Builder<ID, TYPE, BUILDER>>
    extends AbstractEvent.Builder<TYPE, BUILDER> {
        private AbstractDomainEvent<ID> delegate;

        public Builder(TYPE delegate) {
            super(delegate);
            this.delegate = delegate;
        }

        public final BUILDER entityIdPath(@NotNull EntityIdPath entityIdPath) {
            Contract.requireArgNotNull((String)"entityIdPath", (Object)entityIdPath);
            this.delegate.entityIdPath = entityIdPath;
            return (BUILDER)this;
        }

        public final BUILDER entityIdPath(@NotNull AggregateRootId id) {
            Contract.requireArgNotNull((String)"id", (Object)id);
            this.delegate.entityIdPath = new EntityIdPath(new EntityId[]{id});
            return (BUILDER)this;
        }

        public final BUILDER aggregateVersion(AggregateVersion aggregateVersion) {
            this.delegate.aggregateVersion = aggregateVersion;
            return (BUILDER)this;
        }

        protected final void ensureBuildableAbstractDomainEvent() {
            this.ensureBuildableAbstractEvent();
            this.ensureNotNull("entityIdPath", this.delegate.entityIdPath);
        }

        protected final void resetAbstractDomainEvent(TYPE delegate) {
            this.resetAbstractEvent(delegate);
            this.delegate = delegate;
        }
    }
}

