/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.esc.api;

import jakarta.validation.constraints.NotNull;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import org.fuin.esc.api.CommonEvent;
import org.fuin.esc.api.EventStore;
import org.fuin.esc.api.EventStoreAsync;
import org.fuin.esc.api.StreamAlreadyExistsException;
import org.fuin.esc.api.StreamEventsSlice;
import org.fuin.esc.api.StreamId;
import org.fuin.esc.api.StreamState;
import org.fuin.objects4j.common.Contract;

public final class DelegatingAsyncEventStore
implements EventStoreAsync {
    private Executor executor;
    private EventStore delegate;

    public DelegatingAsyncEventStore(@NotNull Executor executor, @NotNull EventStore delegate) {
        Contract.requireArgNotNull((String)"executor", (Object)executor);
        Contract.requireArgNotNull((String)"delegate", (Object)delegate);
        this.executor = executor;
        this.delegate = delegate;
    }

    @Override
    public final CompletableFuture<Void> open() {
        return CompletableFuture.runAsync(new Runnable(){

            @Override
            public void run() {
                DelegatingAsyncEventStore.this.delegate.open();
            }
        }, this.executor);
    }

    @Override
    public final void close() {
        this.delegate.close();
    }

    @Override
    public final CompletableFuture<CommonEvent> readEvent(final StreamId streamId, final long eventNumber) {
        return CompletableFuture.supplyAsync(new Supplier<CommonEvent>(){

            @Override
            public CommonEvent get() {
                return DelegatingAsyncEventStore.this.delegate.readEvent(streamId, eventNumber);
            }
        }, this.executor);
    }

    @Override
    public final CompletableFuture<StreamEventsSlice> readEventsForward(final StreamId streamId, final long start, final int count) {
        return CompletableFuture.supplyAsync(new Supplier<StreamEventsSlice>(){

            @Override
            public StreamEventsSlice get() {
                return DelegatingAsyncEventStore.this.delegate.readEventsForward(streamId, start, count);
            }
        }, this.executor);
    }

    @Override
    public final CompletableFuture<StreamEventsSlice> readEventsBackward(final StreamId streamId, final long start, final int count) {
        return CompletableFuture.supplyAsync(new Supplier<StreamEventsSlice>(){

            @Override
            public StreamEventsSlice get() {
                return DelegatingAsyncEventStore.this.delegate.readEventsBackward(streamId, start, count);
            }
        }, this.executor);
    }

    @Override
    public final CompletableFuture<Void> deleteStream(final StreamId streamId, final long expected, final boolean hardDelete) {
        return CompletableFuture.runAsync(new Runnable(){

            @Override
            public void run() {
                DelegatingAsyncEventStore.this.delegate.deleteStream(streamId, expected, hardDelete);
            }
        }, this.executor);
    }

    @Override
    public final CompletableFuture<Void> deleteStream(final StreamId streamId, final boolean hardDelete) {
        return CompletableFuture.runAsync(new Runnable(){

            @Override
            public void run() {
                DelegatingAsyncEventStore.this.delegate.deleteStream(streamId, hardDelete);
            }
        }, this.executor);
    }

    @Override
    public final CompletableFuture<Long> appendToStream(final StreamId streamId, final long expectedVersion, final List<CommonEvent> toAppend) {
        return CompletableFuture.supplyAsync(new Supplier<Long>(){

            @Override
            public Long get() {
                return DelegatingAsyncEventStore.this.delegate.appendToStream(streamId, expectedVersion, toAppend);
            }
        }, this.executor);
    }

    @Override
    public final CompletableFuture<Long> appendToStream(final StreamId streamId, final long expectedVersion, final CommonEvent ... events) {
        return CompletableFuture.supplyAsync(new Supplier<Long>(){

            @Override
            public Long get() {
                return DelegatingAsyncEventStore.this.delegate.appendToStream(streamId, expectedVersion, events);
            }
        }, this.executor);
    }

    @Override
    public final CompletableFuture<Long> appendToStream(final StreamId streamId, final List<CommonEvent> toAppend) {
        return CompletableFuture.supplyAsync(new Supplier<Long>(){

            @Override
            public Long get() {
                return DelegatingAsyncEventStore.this.delegate.appendToStream(streamId, toAppend);
            }
        }, this.executor);
    }

    @Override
    public final CompletableFuture<Long> appendToStream(final StreamId streamId, final CommonEvent ... events) {
        return CompletableFuture.supplyAsync(new Supplier<Long>(){

            @Override
            public Long get() {
                return DelegatingAsyncEventStore.this.delegate.appendToStream(streamId, events);
            }
        }, this.executor);
    }

    @Override
    public final CompletableFuture<Boolean> streamExists(final StreamId streamId) {
        return CompletableFuture.supplyAsync(new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                return DelegatingAsyncEventStore.this.delegate.streamExists(streamId);
            }
        }, this.executor);
    }

    @Override
    public final CompletableFuture<StreamState> streamState(final StreamId streamId) {
        return CompletableFuture.supplyAsync(new Supplier<StreamState>(){

            @Override
            public StreamState get() {
                return DelegatingAsyncEventStore.this.delegate.streamState(streamId);
            }
        }, this.executor);
    }

    @Override
    public final boolean isSupportsCreateStream() {
        return this.delegate.isSupportsCreateStream();
    }

    @Override
    public CompletableFuture<Void> createStream(final StreamId streamId) throws StreamAlreadyExistsException {
        return CompletableFuture.runAsync(new Runnable(){

            @Override
            public void run() {
                DelegatingAsyncEventStore.this.delegate.createStream(streamId);
            }
        }, this.executor);
    }
}

