/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.esc.api;

import jakarta.validation.constraints.NotNull;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.io.Serializable;
import java.util.UUID;
import org.fuin.esc.api.EventIdConverter;
import org.fuin.objects4j.common.Contract;
import org.fuin.objects4j.common.Immutable;
import org.fuin.objects4j.vo.UUIDStr;
import org.fuin.objects4j.vo.UUIDStrValidator;
import org.fuin.objects4j.vo.ValueObjectWithBaseType;

@XmlJavaTypeAdapter(value=EventIdConverter.class)
@Immutable
public final class EventId
implements ValueObjectWithBaseType<UUID>,
Comparable<EventId>,
Serializable {
    private static final long serialVersionUID = 1000L;
    private long mostSigBits;
    private long leastSigBits;
    private transient UUID uuid;
    private transient String str;

    public EventId() {
        this(UUID.randomUUID());
    }

    public EventId(@NotNull @UUIDStr String value) {
        this(EventId.parseArg("value", value));
    }

    public EventId(@NotNull UUID value) {
        Contract.requireArgNotNull((String)"value", (Object)value);
        this.uuid = value;
        this.mostSigBits = this.uuid.getMostSignificantBits();
        this.leastSigBits = this.uuid.getLeastSignificantBits();
    }

    public final Class<UUID> getBaseType() {
        return UUID.class;
    }

    public final UUID asBaseType() {
        if (this.uuid == null) {
            this.uuid = new UUID(this.mostSigBits, this.leastSigBits);
        }
        return this.uuid;
    }

    public final String toString() {
        if (this.str == null) {
            this.str = this.uuid.toString();
        }
        return this.str;
    }

    public final int hashCode() {
        return this.asBaseType().hashCode();
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventId)) {
            return false;
        }
        EventId other = (EventId)obj;
        return this.asBaseType().equals(other.asBaseType());
    }

    @Override
    public final int compareTo(EventId other) {
        return this.asBaseType().compareTo(other.asBaseType());
    }

    private static UUID parseArg(String name, String value) {
        Contract.requireArgNotNull((String)name, (Object)value);
        return UUIDStrValidator.parseArg((String)name, (String)value);
    }
}

