/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.esc.api;

import jakarta.validation.constraints.NotNull;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.fuin.esc.api.CommonEvent;
import org.fuin.esc.api.EventStore;
import org.fuin.esc.api.EventStoreAsync;
import org.fuin.esc.api.StreamAlreadyExistsException;
import org.fuin.esc.api.StreamEventsSlice;
import org.fuin.esc.api.StreamId;
import org.fuin.esc.api.StreamState;
import org.fuin.objects4j.common.Contract;

public final class DelegatingAsyncEventStore
implements EventStoreAsync {
    private final Executor executor;
    private final EventStore delegate;

    public DelegatingAsyncEventStore(@NotNull Executor executor, @NotNull EventStore delegate) {
        Contract.requireArgNotNull((String)"executor", (Object)executor);
        Contract.requireArgNotNull((String)"delegate", (Object)delegate);
        this.executor = executor;
        this.delegate = delegate;
    }

    @Override
    public CompletableFuture<Void> open() {
        return CompletableFuture.runAsync(this.delegate::open, this.executor);
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    @Override
    public CompletableFuture<CommonEvent> readEvent(StreamId streamId, long eventNumber) {
        return CompletableFuture.supplyAsync(() -> this.delegate.readEvent(streamId, eventNumber), this.executor);
    }

    @Override
    public CompletableFuture<StreamEventsSlice> readEventsForward(StreamId streamId, long start, int count) {
        return CompletableFuture.supplyAsync(() -> this.delegate.readEventsForward(streamId, start, count), this.executor);
    }

    @Override
    public CompletableFuture<StreamEventsSlice> readEventsBackward(StreamId streamId, long start, int count) {
        return CompletableFuture.supplyAsync(() -> this.delegate.readEventsBackward(streamId, start, count), this.executor);
    }

    @Override
    public CompletableFuture<Void> deleteStream(StreamId streamId, long expected, boolean hardDelete) {
        return CompletableFuture.runAsync(() -> this.delegate.deleteStream(streamId, expected, hardDelete), this.executor);
    }

    @Override
    public CompletableFuture<Void> deleteStream(StreamId streamId, boolean hardDelete) {
        return CompletableFuture.runAsync(() -> this.delegate.deleteStream(streamId, hardDelete), this.executor);
    }

    @Override
    public CompletableFuture<Long> appendToStream(StreamId streamId, long expectedVersion, List<CommonEvent> toAppend) {
        return CompletableFuture.supplyAsync(() -> this.delegate.appendToStream(streamId, expectedVersion, toAppend), this.executor);
    }

    @Override
    public CompletableFuture<Long> appendToStream(StreamId streamId, long expectedVersion, CommonEvent ... events) {
        return CompletableFuture.supplyAsync(() -> this.delegate.appendToStream(streamId, expectedVersion, events), this.executor);
    }

    @Override
    public CompletableFuture<Long> appendToStream(StreamId streamId, List<CommonEvent> toAppend) {
        return CompletableFuture.supplyAsync(() -> this.delegate.appendToStream(streamId, toAppend), this.executor);
    }

    @Override
    public CompletableFuture<Long> appendToStream(StreamId streamId, CommonEvent ... events) {
        return CompletableFuture.supplyAsync(() -> this.delegate.appendToStream(streamId, events), this.executor);
    }

    @Override
    public CompletableFuture<Boolean> streamExists(StreamId streamId) {
        return CompletableFuture.supplyAsync(() -> this.delegate.streamExists(streamId), this.executor);
    }

    @Override
    public CompletableFuture<StreamState> streamState(StreamId streamId) {
        return CompletableFuture.supplyAsync(() -> this.delegate.streamState(streamId), this.executor);
    }

    @Override
    public boolean isSupportsCreateStream() {
        return this.delegate.isSupportsCreateStream();
    }

    @Override
    public CompletableFuture<Void> createStream(StreamId streamId) throws StreamAlreadyExistsException {
        return CompletableFuture.runAsync(() -> this.delegate.createStream(streamId), this.executor);
    }
}

