/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.esc.api;

import jakarta.validation.constraints.NotNull;
import javax.annotation.concurrent.Immutable;
import org.fuin.esc.api.StreamId;
import org.fuin.objects4j.common.Contract;

@Immutable
public final class EventNotFoundException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private final StreamId streamId;
    private final long version;

    public EventNotFoundException(@NotNull StreamId streamId, long eventNumber) {
        super("Version " + eventNumber + " does not exist on stream '" + String.valueOf(streamId) + "'");
        Contract.requireArgNotNull((String)"streamId", (Object)streamId);
        this.streamId = streamId;
        this.version = eventNumber;
    }

    @NotNull
    public StreamId getStreamId() {
        return this.streamId;
    }

    public long getVersion() {
        return this.version;
    }
}

