/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.esc.api;

import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.fuin.esc.api.HasSerializedDataTypeConstant;
import org.fuin.esc.api.SerializedDataType;

public final class HasSerializedDataTypeConstantValidator
implements ConstraintValidator<HasSerializedDataTypeConstant, Object> {
    private String name;

    public void initialize(HasSerializedDataTypeConstant annotation) {
        this.name = annotation.value();
    }

    public boolean isValid(Object obj, ConstraintValidatorContext context) {
        Result result = HasSerializedDataTypeConstantValidator.analyze(obj.getClass(), this.name);
        if (result.message() == null) {
            return true;
        }
        this.error(context, result.message());
        return false;
    }

    private void error(ConstraintValidatorContext context, String message) {
        context.disableDefaultConstraintViolation();
        context.buildConstraintViolationWithTemplate(message).addConstraintViolation();
    }

    private static Result analyze(Class<?> clasz, String name) {
        try {
            Field field = clasz.getField(name);
            int modifiers = field.getModifiers();
            if (!Modifier.isStatic(modifiers)) {
                return new Result("Field '" + name + "' is not static (#1)", null);
            }
            if (field.getType() != SerializedDataType.class) {
                return new Result("Expected constant '" + name + "' to be of type '" + SerializedDataType.class.getName() + "', but was: " + field.getType().getName() + " (#3)", null);
            }
            Object value = field.get(clasz);
            if (value == null) {
                return new Result("Constant '" + name + "' is expected to be a non-null value (#4)", null);
            }
            if (!Modifier.isFinal(modifiers)) {
                return new Result("Constant '" + name + "' is not not final (#5)", null);
            }
            return new Result(null, value);
        }
        catch (NoSuchFieldException ex) {
            return new Result("The field '" + name + "' is undefined or it is not public (#2)", null);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalStateException("Failed to execute method", ex);
        }
    }

    public static SerializedDataType extractValue(Class<?> clasz, String fieldName) {
        Result result = HasSerializedDataTypeConstantValidator.analyze(clasz, fieldName);
        if (result.message() == null) {
            return (SerializedDataType)((Object)result.value());
        }
        throw new IllegalArgumentException(result.message() + " (" + String.valueOf(clasz) + ")");
    }

    private record Result(String message, Object value) {
    }
}

