/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.esc.api;

import jakarta.validation.constraints.NotNull;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.fuin.esc.api.SerializedDataType;
import org.fuin.esc.api.SerializedDataType2ClassMapping;
import org.fuin.esc.api.SerializedDataTypeRegistry;
import org.fuin.objects4j.common.Contract;

public final class SimpleSerializedDataTypeRegistry
implements SerializedDataTypeRegistry {
    private final Map<SerializedDataType, Class<?>> map = new HashMap();

    private SimpleSerializedDataTypeRegistry() {
    }

    private void add(@NotNull SerializedDataType type, Class<?> clasz) {
        this.map.put(type, clasz);
    }

    private void add(@NotNull SerializedDataType2ClassMapping mapping) {
        this.map.put(mapping.type(), mapping.clasz());
    }

    @Override
    @NotNull
    public Class<?> findClass(@NotNull SerializedDataType type) {
        Contract.requireArgNotNull((String)"type", (Object)((Object)type));
        Class<?> clasz = this.map.get((Object)type);
        if (clasz == null) {
            throw new IllegalArgumentException("No class found for: " + String.valueOf((Object)type));
        }
        return clasz;
    }

    @Override
    public Set<SerializedDataTypeRegistry.TypeClass> findAll() {
        return this.map.entrySet().stream().map(e -> new SerializedDataTypeRegistry.TypeClass((SerializedDataType)((Object)((Object)e.getKey())), (Class)e.getValue())).collect(Collectors.toSet());
    }

    public static final class Builder
    implements SerializedDataTypeRegistry.Builder<SimpleSerializedDataTypeRegistry, Builder> {
        private SimpleSerializedDataTypeRegistry delegate = new SimpleSerializedDataTypeRegistry();

        @Override
        public Builder add(SerializedDataType type, Class<?> clasz) {
            Contract.requireArgNotNull((String)"type", (Object)((Object)type));
            Contract.requireArgNotNull((String)"clasz", clasz);
            this.delegate.add(type, clasz);
            return this;
        }

        @Override
        public Builder add(SerializedDataType2ClassMapping mapping) {
            Contract.requireArgNotNull((String)"mapping", (Object)mapping);
            this.delegate.add(mapping);
            return this;
        }

        @Override
        public SimpleSerializedDataTypeRegistry build() {
            SimpleSerializedDataTypeRegistry tmp = this.delegate;
            this.delegate = new SimpleSerializedDataTypeRegistry();
            return tmp;
        }
    }
}

