/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.esc.api;

import jakarta.validation.constraints.NotNull;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.fuin.esc.api.Deserializer;
import org.fuin.esc.api.EnhancedMimeType;
import org.fuin.esc.api.SerDeserializer;
import org.fuin.esc.api.SerDeserializerRegistry;
import org.fuin.esc.api.SerializedDataType;
import org.fuin.esc.api.Serializer;
import org.fuin.objects4j.common.Contract;

public final class SimpleSerializerDeserializerRegistry
implements SerDeserializerRegistry {
    private final EnhancedMimeType defaultMimeType;
    private final Map<SerializedDataType, Serializer> serMap = new HashMap<SerializedDataType, Serializer>();
    private final Map<Key, Deserializer> desMap = new HashMap<Key, Deserializer>();

    private SimpleSerializerDeserializerRegistry(EnhancedMimeType defaultMimeType) {
        this.defaultMimeType = Objects.requireNonNull(defaultMimeType, "defaultMimeType==null");
    }

    private void addSerDeserializer(@NotNull SerializedDataType type, @NotNull SerDeserializer serDeserializer, EnhancedMimeType mimeType) {
        this.addSerializer(type, serDeserializer);
        this.addDeserializer(type, serDeserializer, mimeType);
    }

    private void addDeserializer(@NotNull SerializedDataType type, @NotNull Deserializer deserializer, EnhancedMimeType mimeType) {
        Key key = new Key(type, mimeType == null ? this.defaultMimeType : mimeType);
        this.desMap.put(key, deserializer);
    }

    private void addSerializer(@NotNull SerializedDataType type, @NotNull Serializer serializer) {
        this.serMap.put(type, serializer);
    }

    @Override
    public Serializer getSerializer(SerializedDataType type) {
        Contract.requireArgNotNull((String)"type", (Object)((Object)type));
        Serializer ser = this.serMap.get((Object)type);
        if (ser == null) {
            throw new IllegalArgumentException("No serializer found for: " + String.valueOf((Object)type));
        }
        return ser;
    }

    @Override
    public Deserializer getDeserializer(SerializedDataType type, EnhancedMimeType mimeType) {
        Contract.requireArgNotNull((String)"type", (Object)((Object)type));
        Contract.requireArgNotNull((String)"mimeType", (Object)((Object)mimeType));
        Key key = new Key(type, mimeType);
        Deserializer des = this.desMap.get(key);
        if (des == null) {
            throw new IllegalArgumentException("No deserializer found for: " + String.valueOf(key));
        }
        return des;
    }

    @Override
    public Deserializer getDeserializer(SerializedDataType type) {
        Contract.requireArgNotNull((String)"type", (Object)((Object)type));
        Key key = new Key(type, this.defaultMimeType);
        Deserializer des = this.desMap.get(key);
        if (des == null) {
            throw new IllegalArgumentException("No deserializer found for: " + String.valueOf(key));
        }
        return des;
    }

    @Override
    public EnhancedMimeType getDefaultMimeType() {
        return this.defaultMimeType;
    }

    @Override
    public boolean serializerExists(SerializedDataType type) {
        Serializer ser = this.serMap.get((Object)type);
        return ser != null;
    }

    @Override
    public boolean deserializerExists(SerializedDataType type) {
        Contract.requireArgNotNull((String)"type", (Object)((Object)type));
        Key key = new Key(type, this.defaultMimeType);
        Deserializer des = this.desMap.get(key);
        return des != null;
    }

    @Override
    public boolean deserializerExists(SerializedDataType type, EnhancedMimeType mimeType) {
        Contract.requireArgNotNull((String)"type", (Object)((Object)type));
        Contract.requireArgNotNull((String)"mimeType", (Object)((Object)mimeType));
        Key key = new Key(type, mimeType);
        Deserializer des = this.desMap.get(key);
        return des != null;
    }

    private static class Key {
        private final SerializedDataType type;
        private final EnhancedMimeType mimeType;

        public Key(SerializedDataType type, EnhancedMimeType mimeType) {
            this.type = Objects.requireNonNull(type, "type ==null");
            Objects.requireNonNull(mimeType, "mimeType ==null");
            this.mimeType = EnhancedMimeType.create(mimeType.getPrimaryType(), mimeType.getSubType(), mimeType.getEncoding(), mimeType.getVersion());
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            return Objects.equals((Object)this.type, (Object)key.type) && Objects.equals((Object)this.mimeType, (Object)key.mimeType);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type, this.mimeType});
        }

        public String toString() {
            return "Key [type=" + String.valueOf((Object)this.type) + ", mimeType=" + String.valueOf((Object)this.mimeType) + "]";
        }
    }

    public static final class Builder
    implements SerDeserializerRegistry.Builder<SimpleSerializerDeserializerRegistry, Builder> {
        private SimpleSerializerDeserializerRegistry delegate;

        public Builder(EnhancedMimeType defaultMimeType) {
            this.delegate = new SimpleSerializerDeserializerRegistry(defaultMimeType);
        }

        @Override
        public Builder add(SerializedDataType type, SerDeserializer serDeserializer, EnhancedMimeType mimeType) {
            Objects.requireNonNull(type, "type==null");
            Objects.requireNonNull(serDeserializer, "serDeserializer==null");
            this.delegate.addSerDeserializer(type, serDeserializer, mimeType);
            return this;
        }

        @Override
        public Builder add(SerializedDataType type, SerDeserializer serDeserializer) {
            Objects.requireNonNull(type, "type==null");
            Objects.requireNonNull(serDeserializer, "serDeserializer==null");
            this.delegate.addSerDeserializer(type, serDeserializer, null);
            return this;
        }

        @Override
        public Builder add(SerializedDataType type, Deserializer deserializer, EnhancedMimeType mimeType) {
            Objects.requireNonNull(type, "type==null");
            Objects.requireNonNull(deserializer, "deserializer==null");
            this.delegate.addDeserializer(type, deserializer, mimeType);
            return this;
        }

        @Override
        public Builder add(SerializedDataType type, Deserializer deserializer) {
            Objects.requireNonNull(type, "type==null");
            Objects.requireNonNull(deserializer, "deserializer==null");
            this.delegate.addDeserializer(type, deserializer, null);
            return this;
        }

        @Override
        public Builder add(SerializedDataType type, Serializer serializer) {
            Objects.requireNonNull(type, "type==null");
            Objects.requireNonNull(serializer, "serializer==null");
            this.delegate.addSerializer(type, serializer);
            return this;
        }

        @Override
        public SimpleSerializerDeserializerRegistry build() {
            SimpleSerializerDeserializerRegistry tmp = this.delegate;
            this.delegate = new SimpleSerializerDeserializerRegistry(tmp.getDefaultMimeType());
            return tmp;
        }
    }
}

