/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.esc.api;

import jakarta.annotation.Nullable;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.concurrent.Immutable;
import org.fuin.esc.api.CommonEvent;

@Immutable
public final class StreamEventsSlice {
    private final long fromEventNumber;
    private final long nextEventNumber;
    private final boolean endOfStream;
    private final List<CommonEvent> events;

    public StreamEventsSlice(long fromEventNumber, @Nullable List<CommonEvent> events, long nextEventNumber, boolean endOfStream) {
        this.fromEventNumber = fromEventNumber;
        this.events = events == null || events.isEmpty() ? new ArrayList<CommonEvent>() : new ArrayList<CommonEvent>(events);
        this.nextEventNumber = nextEventNumber;
        this.endOfStream = endOfStream;
    }

    public long getFromEventNumber() {
        return this.fromEventNumber;
    }

    @NotNull
    public List<CommonEvent> getEvents() {
        return Collections.unmodifiableList(this.events);
    }

    public long getNextEventNumber() {
        return this.nextEventNumber;
    }

    public boolean isEndOfStream() {
        return this.endOfStream;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.endOfStream ? 1231 : 1237);
        result = 31 * result + (int)(this.fromEventNumber ^ this.fromEventNumber >>> 32);
        result = 31 * result + (int)(this.nextEventNumber ^ this.nextEventNumber >>> 32);
        result = 31 * result + (this.events == null ? 0 : Arrays.hashCode(this.events.toArray()));
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StreamEventsSlice)) {
            return false;
        }
        StreamEventsSlice other = (StreamEventsSlice)obj;
        if (this.endOfStream != other.endOfStream) {
            return false;
        }
        if (this.fromEventNumber != other.fromEventNumber) {
            return false;
        }
        if (this.nextEventNumber != other.nextEventNumber) {
            return false;
        }
        if (this.events == null) {
            return other.events == null;
        }
        if (other.events == null) {
            return false;
        }
        return Arrays.equals(this.events.toArray(), other.events.toArray());
    }

    public String toString() {
        return "StreamEventsSlice{fromEventNumber=" + this.fromEventNumber + ", nextEventNumber=" + this.nextEventNumber + ", endOfStream=" + this.endOfStream + ", events.size=" + this.events.size() + "}";
    }
}

