/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.esc.client;

import jakarta.validation.constraints.NotNull;
import java.io.File;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.fuin.esc.api.HasSerializedDataTypeConstant;
import org.fuin.esc.api.HasSerializedDataTypeConstantValidator;
import org.fuin.esc.api.SerializedDataType;
import org.fuin.esc.api.SerializedDataTypeRegistry;
import org.fuin.esc.api.SimpleSerializedDataTypeRegistry;
import org.fuin.utils4j.jandex.JandexIndexFileReader;
import org.fuin.utils4j.jandex.JandexUtils;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.CompositeIndex;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Indexer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JandexSerializedDataTypeRegistry
implements SerializedDataTypeRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(JandexSerializedDataTypeRegistry.class);
    private final SerializedDataTypeRegistry delegate;
    private final List<File> classesDirs;
    private final Set<Class<?>> classes;

    public JandexSerializedDataTypeRegistry() {
        this(new File("target/classes"));
    }

    public JandexSerializedDataTypeRegistry(File ... classesDirs) {
        SimpleSerializedDataTypeRegistry.Builder builder = new SimpleSerializedDataTypeRegistry.Builder();
        this.classesDirs = Arrays.asList(classesDirs);
        this.classes = this.scanForClasses();
        for (Class<?> domainEventClass : this.classes) {
            builder.add(JandexSerializedDataTypeRegistry.serializedDataTypeConstant(domainEventClass), domainEventClass);
        }
        this.delegate = builder.build();
    }

    @NotNull
    public Class<?> findClass(@NotNull SerializedDataType type) {
        return this.delegate.findClass(type);
    }

    @NotNull
    public Set<SerializedDataTypeRegistry.TypeClass> findAll() {
        return this.delegate.findAll();
    }

    public Set<Class<?>> getClasses() {
        return Collections.unmodifiableSet(this.classes);
    }

    private Set<Class<?>> scanForClasses() {
        ArrayList<IndexView> indexes = new ArrayList<IndexView>();
        indexes.add(new JandexIndexFileReader.Builder().addDefaultResource().build().loadR());
        indexes.add(this.indexClassesDirs());
        return JandexSerializedDataTypeRegistry.findClasses((IndexView)CompositeIndex.create(indexes));
    }

    private IndexView indexClassesDirs() {
        Indexer indexer = new Indexer();
        ArrayList knownClassFiles = new ArrayList();
        for (File classesDir : this.classesDirs) {
            JandexUtils.indexDir((Indexer)indexer, knownClassFiles, (File)classesDir);
        }
        return indexer.complete();
    }

    private static Set<Class<?>> findClasses(IndexView index) {
        HashSet classes = new HashSet();
        Collection annotationInstances = index.getAnnotations(DotName.createSimple(HasSerializedDataTypeConstant.class));
        for (AnnotationInstance annotationInstance : annotationInstances) {
            ClassInfo classInfo = annotationInstance.target().asClass();
            if (Modifier.isAbstract(classInfo.flags()) || Modifier.isInterface(classInfo.flags()) || classInfo.name().toString().contains("$")) continue;
            Class clasz = JandexUtils.loadClass((DotName)classInfo.name());
            classes.add(clasz);
            LOG.info("Added SerializedDataType to {}: {}", (Object)JandexSerializedDataTypeRegistry.class.getSimpleName(), (Object)clasz.getName());
        }
        return classes;
    }

    private static SerializedDataType serializedDataTypeConstant(Class<?> domainEventClass) {
        HasSerializedDataTypeConstant annotation = domainEventClass.getAnnotation(HasSerializedDataTypeConstant.class);
        return HasSerializedDataTypeConstantValidator.extractValue(domainEventClass, (String)annotation.value());
    }
}

