/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.esc.esgrpc;

import com.eventstore.dbclient.EventData;
import com.eventstore.dbclient.EventDataBuilder;
import jakarta.validation.constraints.NotNull;
import java.nio.charset.Charset;
import java.util.UUID;
import org.fuin.esc.api.CommonEvent;
import org.fuin.esc.spi.Base64Data;
import org.fuin.esc.spi.Converter;
import org.fuin.esc.spi.EnhancedMimeType;
import org.fuin.esc.spi.EscMeta;
import org.fuin.esc.spi.EscSpiUtils;
import org.fuin.esc.spi.SerializedDataType;
import org.fuin.esc.spi.Serializer;
import org.fuin.esc.spi.SerializerRegistry;
import org.fuin.objects4j.common.Contract;

public final class CommonEvent2EventDataConverter
implements Converter<CommonEvent, EventData> {
    private static final EnhancedMimeType XML_UTF8 = EnhancedMimeType.create((String)"application", (String)"xml", (Charset)Charset.forName("utf-8"));
    private static final EnhancedMimeType JSON_UTF8 = EnhancedMimeType.create((String)"application", (String)"json", (Charset)Charset.forName("utf-8"));
    private final SerializerRegistry serRegistry;
    private final EnhancedMimeType targetContentType;

    public CommonEvent2EventDataConverter(@NotNull SerializerRegistry serRegistry, EnhancedMimeType targetContentType) {
        Contract.requireArgNotNull((String)"serRegistry", (Object)serRegistry);
        Contract.requireArgNotNull((String)"targetContentType", (Object)targetContentType);
        if (!targetContentType.matchEncoding(JSON_UTF8) && !targetContentType.matchEncoding(XML_UTF8)) {
            throw new IllegalArgumentException("Only 'application/xml' or 'application/json' with 'utf-8' encoding is allowed, but was: " + targetContentType);
        }
        this.serRegistry = serRegistry;
        this.targetContentType = targetContentType;
    }

    public final EventData convert(CommonEvent commonEvent) {
        byte[] serData;
        String dataType = commonEvent.getDataType().asBaseType();
        SerializedDataType serUserDataType = new SerializedDataType(dataType);
        Serializer userDataSerializer = this.serRegistry.getSerializer(serUserDataType);
        byte[] serUserData = userDataSerializer.marshal(commonEvent.getData(), serUserDataType);
        if (userDataSerializer.getMimeType().matchEncoding(this.targetContentType)) {
            serData = serUserData;
        } else {
            Base64Data base64data = new Base64Data(serUserData);
            Serializer base64Serializer = this.serRegistry.getSerializer(Base64Data.SER_TYPE);
            serData = base64Serializer.marshal((Object)base64data, Base64Data.SER_TYPE);
        }
        EscMeta escMeta = EscSpiUtils.createEscMeta((SerializerRegistry)this.serRegistry, (EnhancedMimeType)this.targetContentType, (CommonEvent)commonEvent);
        SerializedDataType escMetaType = new SerializedDataType(EscMeta.TYPE.asBaseType());
        Serializer escMetaSerializer = this.getSerializer(escMetaType);
        byte[] escSerMeta = escMetaSerializer.marshal((Object)escMeta, escMetaType);
        if (this.targetContentType.isJson()) {
            return EventDataBuilder.json((UUID)commonEvent.getId().asBaseType(), (String)dataType, (byte[])serData).metadataAsBytes(escSerMeta).build();
        }
        return EventDataBuilder.binary((UUID)commonEvent.getId().asBaseType(), (String)dataType, (byte[])serData).metadataAsBytes(escSerMeta).build();
    }

    private Serializer getSerializer(SerializedDataType serDataType) {
        Serializer serializer = this.serRegistry.getSerializer(serDataType);
        if (!serializer.getMimeType().matchEncoding(this.targetContentType)) {
            throw new IllegalArgumentException("Target content type is '" + this.targetContentType + "', but serializer returned for " + serDataType + "' was: " + serializer.getMimeType());
        }
        return serializer;
    }

    public final Class<CommonEvent> getSourceType() {
        return CommonEvent.class;
    }

    public final Class<EventData> getTargetType() {
        return EventData.class;
    }
}

