/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.esc.esgrpc;

import com.eventstore.dbclient.CreateProjectionOptions;
import com.eventstore.dbclient.DeleteProjectionOptions;
import com.eventstore.dbclient.EventStoreDBProjectionManagementClient;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.fuin.esc.api.ProjectionAdminEventStore;
import org.fuin.esc.api.StreamAlreadyExistsException;
import org.fuin.esc.api.StreamId;
import org.fuin.esc.api.StreamNotFoundException;
import org.fuin.esc.api.TenantId;
import org.fuin.esc.api.TypeName;
import org.fuin.esc.spi.ProjectionJavaScriptBuilder;
import org.fuin.esc.spi.TenantStreamId;
import org.fuin.objects4j.common.ConstraintViolationException;
import org.fuin.objects4j.common.Contract;

public final class GrpcProjectionAdminEventStore
implements ProjectionAdminEventStore {
    private final EventStoreDBProjectionManagementClient es;
    private final TenantId tenantId;

    public GrpcProjectionAdminEventStore(EventStoreDBProjectionManagementClient es) {
        this(es, null);
    }

    public GrpcProjectionAdminEventStore(EventStoreDBProjectionManagementClient es, TenantId tenantId) {
        Contract.requireArgNotNull((String)"es", (Object)es);
        this.es = es;
        this.tenantId = tenantId;
    }

    public ProjectionAdminEventStore open() {
        return this;
    }

    public void close() {
    }

    public boolean projectionExists(StreamId projectionId) {
        Contract.requireArgNotNull((String)"projectionId", (Object)projectionId);
        GrpcProjectionAdminEventStore.requireProjection(projectionId);
        try {
            this.es.getStatus(new TenantStreamId(this.tenantId, projectionId).asString()).get();
            return true;
        }
        catch (InterruptedException | ExecutionException ex) {
            StatusRuntimeException sre;
            Throwable throwable = ex.getCause();
            if (throwable instanceof StatusRuntimeException && (sre = (StatusRuntimeException)throwable).getStatus().getCode().equals((Object)Status.UNKNOWN.getCode()) && sre.getMessage() != null && sre.getMessage().contains("NotFound")) {
                return false;
            }
            throw new RuntimeException("Error waiting for getStatus(..) result", ex);
        }
    }

    public void enableProjection(StreamId projectionId) throws StreamNotFoundException {
        Contract.requireArgNotNull((String)"projectionId", (Object)projectionId);
        GrpcProjectionAdminEventStore.requireProjection(projectionId);
        try {
            this.es.enable(new TenantStreamId(this.tenantId, projectionId).asString()).get();
        }
        catch (InterruptedException | ExecutionException ex) {
            throw new RuntimeException("Error waiting for enable(..) result", ex);
        }
    }

    public void disableProjection(StreamId projectionId) throws StreamNotFoundException {
        Contract.requireArgNotNull((String)"projectionId", (Object)projectionId);
        GrpcProjectionAdminEventStore.requireProjection(projectionId);
        try {
            this.es.disable(new TenantStreamId(this.tenantId, projectionId).asString()).get();
        }
        catch (InterruptedException | ExecutionException ex) {
            throw new RuntimeException("Error waiting for disable(..) result", ex);
        }
    }

    public void createProjection(StreamId projectionId, boolean enable, TypeName ... eventType) throws StreamAlreadyExistsException {
        this.createProjection(projectionId, enable, Arrays.asList(eventType));
    }

    public void createProjection(StreamId projectionId, boolean enable, List<TypeName> eventTypes) throws StreamAlreadyExistsException {
        Contract.requireArgNotNull((String)"projectionId", (Object)projectionId);
        GrpcProjectionAdminEventStore.requireProjection(projectionId);
        TenantStreamId pid = new TenantStreamId(this.tenantId, projectionId);
        String javascript = new ProjectionJavaScriptBuilder(pid).types(eventTypes).build();
        try {
            this.es.create(pid.asString(), javascript, CreateProjectionOptions.get().emitEnabled(false).trackEmittedStreams(true)).get();
        }
        catch (InterruptedException | ExecutionException ex) {
            throw new RuntimeException("Error waiting for create(..) result", ex);
        }
        if (enable) {
            this.enableProjection((StreamId)pid);
        } else {
            this.disableProjection((StreamId)pid);
        }
    }

    public void deleteProjection(StreamId projectionId) throws StreamNotFoundException {
        Contract.requireArgNotNull((String)"projectionId", (Object)projectionId);
        GrpcProjectionAdminEventStore.requireProjection(projectionId);
        this.disableProjection(projectionId);
        TenantStreamId pid = new TenantStreamId(this.tenantId, projectionId);
        try {
            this.es.delete(pid.asString(), DeleteProjectionOptions.get().deleteCheckpointStream().deleteStateStream().deleteEmittedStreams()).get();
        }
        catch (InterruptedException | ExecutionException ex) {
            throw new RuntimeException("Error waiting for delete(..) result", ex);
        }
    }

    static void requireProjection(StreamId projectionId) {
        if (!projectionId.isProjection()) {
            throw new ConstraintViolationException("The stream identifier is not a projection id");
        }
    }
}

