/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.esc.esgrpc;

import com.eventstore.dbclient.RecordedEvent;
import jakarta.validation.constraints.NotNull;
import java.nio.charset.Charset;
import org.fuin.esc.api.CommonEvent;
import org.fuin.esc.api.EventId;
import org.fuin.esc.api.SimpleCommonEvent;
import org.fuin.esc.api.TypeName;
import org.fuin.esc.spi.Base64Data;
import org.fuin.esc.spi.Converter;
import org.fuin.esc.spi.Deserializer;
import org.fuin.esc.spi.DeserializerRegistry;
import org.fuin.esc.spi.EnhancedMimeType;
import org.fuin.esc.spi.EscMeta;
import org.fuin.esc.spi.SerializedDataType;
import org.fuin.objects4j.common.Contract;

public final class RecordedEvent2CommonEventConverter
implements Converter<RecordedEvent, CommonEvent> {
    private final DeserializerRegistry deserRegistry;

    public RecordedEvent2CommonEventConverter(@NotNull DeserializerRegistry deserRegistry) {
        Contract.requireArgNotNull((String)"deserRegistry", (Object)deserRegistry);
        this.deserRegistry = deserRegistry;
    }

    public final CommonEvent convert(RecordedEvent eventData) {
        EnhancedMimeType escMetaMimeType = this.metaMimeType(eventData.getContentType().equals("application/json"));
        SerializedDataType escSerMetaType = new SerializedDataType(EscMeta.TYPE.asBaseType());
        Deserializer escMetaDeserializer = this.deserRegistry.getDeserializer(escSerMetaType, escMetaMimeType);
        EscMeta escMeta = (EscMeta)escMetaDeserializer.unmarshal((Object)eventData.getUserMetadata(), escSerMetaType, escMetaMimeType);
        EnhancedMimeType metaMimeType = escMeta.getMetaContentType();
        String metaTransferEncoding = escMeta.getMetaType() == null ? null : escMeta.getMetaContentType().getParameter("transfer-encoding");
        EnhancedMimeType dataMimeType = escMeta.getDataContentType();
        SerializedDataType serDataType = new SerializedDataType(escMeta.getDataType());
        Deserializer dataDeserializer = this.deserRegistry.getDeserializer(serDataType, dataMimeType);
        String dataTransferEncoding = escMeta.getDataContentType().getParameter("transfer-encoding");
        Object data = this.unmarshal(dataTransferEncoding, serDataType, dataDeserializer, dataMimeType, eventData.getEventData(), metaMimeType, escMetaMimeType);
        EventId eventId = new EventId(eventData.getEventId());
        TypeName dataType = new TypeName(eventData.getEventType());
        if (escMeta.getMetaType() == null) {
            return new SimpleCommonEvent(eventId, dataType, data);
        }
        TypeName metaType = new TypeName(escMeta.getMetaType());
        SerializedDataType serMetaType = new SerializedDataType(escMeta.getMetaType());
        Deserializer metaDeserializer = this.deserRegistry.getDeserializer(serMetaType, metaMimeType);
        Object meta = this.unmarshal(metaTransferEncoding, serMetaType, metaDeserializer, metaMimeType, escMeta.getMeta(), metaMimeType, escMetaMimeType);
        return new SimpleCommonEvent(eventId, dataType, data, metaType, meta);
    }

    private Object unmarshal(String transferEncoding, SerializedDataType dataType, Deserializer dataDeserializer, EnhancedMimeType dataMimeType, Object data, EnhancedMimeType metaMimeType, EnhancedMimeType escMetaMimeType) {
        if (transferEncoding == null) {
            return dataDeserializer.unmarshal(data, dataType, dataMimeType);
        }
        if (data instanceof Base64Data) {
            Base64Data base64Data = (Base64Data)data;
            return dataDeserializer.unmarshal((Object)base64Data.getDecoded(), dataType, dataMimeType);
        }
        Deserializer base64Deserializer = this.deserRegistry.getDeserializer(Base64Data.SER_TYPE, escMetaMimeType);
        Base64Data base64Data = (Base64Data)base64Deserializer.unmarshal(data, Base64Data.SER_TYPE, metaMimeType);
        return dataDeserializer.unmarshal((Object)base64Data.getDecoded(), dataType, dataMimeType);
    }

    private EnhancedMimeType metaMimeType(boolean json) {
        if (json) {
            return EnhancedMimeType.create((String)"application", (String)"json", (Charset)Charset.forName("utf-8"));
        }
        return EnhancedMimeType.create((String)"application", (String)"xml", (Charset)Charset.forName("utf-8"));
    }

    public final Class<RecordedEvent> getSourceType() {
        return RecordedEvent.class;
    }

    public final Class<CommonEvent> getTargetType() {
        return CommonEvent.class;
    }
}

