/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.esc.esgrpc.example;

import com.eventstore.dbclient.DeleteResult;
import com.eventstore.dbclient.DeleteStreamOptions;
import com.eventstore.dbclient.EventData;
import com.eventstore.dbclient.EventStoreDBClient;
import com.eventstore.dbclient.EventStoreDBClientSettings;
import com.eventstore.dbclient.EventStoreDBConnectionString;
import com.eventstore.dbclient.ReadResult;
import com.eventstore.dbclient.ReadStreamOptions;
import com.eventstore.dbclient.ResolvedEvent;
import com.eventstore.dbclient.WriteResult;
import java.io.IOException;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import org.fuin.esc.esgrpc.example.AccountCreated;

public class App {
    public static void main(String[] args) throws InterruptedException, ExecutionException, IOException {
        System.out.println("BEGIN");
        EventStoreDBClientSettings setts = EventStoreDBConnectionString.parseOrThrow((String)"esdb://localhost:2113?tls=false");
        EventStoreDBClient client = EventStoreDBClient.create((EventStoreDBClientSettings)setts);
        AccountCreated createdEvent = new AccountCreated();
        createdEvent.setId(UUID.randomUUID());
        createdEvent.setLogin("ouros");
        EventData event = EventData.builderAsJson((String)"account-created", (Object)createdEvent).build();
        String streamName = "accounts3";
        WriteResult writeResult = (WriteResult)client.appendToStream(streamName, new EventData[]{event}).get();
        System.out.println("writeResult=" + writeResult);
        ReadStreamOptions readStreamOptions = (ReadStreamOptions)((ReadStreamOptions)ReadStreamOptions.get().fromStart()).maxCount(1L).notResolveLinkTos();
        ReadResult readResult = (ReadResult)client.readStream(streamName, readStreamOptions).get();
        System.out.println("readResult=" + readResult);
        ResolvedEvent resolvedEvent = (ResolvedEvent)readResult.getEvents().get(0);
        System.out.println("resolvedEvent=" + resolvedEvent);
        AccountCreated writtenEvent = (AccountCreated)resolvedEvent.getOriginalEvent().getEventDataAs(AccountCreated.class);
        System.out.println("writtenEvent=" + writtenEvent);
        DeleteResult deleteResult = (DeleteResult)client.tombstoneStream(streamName, DeleteStreamOptions.get()).get();
        System.out.println("deleteResult=" + deleteResult);
        System.out.println("END");
    }
}

