/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.esc.esgrpc;

import io.kurrent.dbclient.EventData;
import io.kurrent.dbclient.EventDataBuilder;
import jakarta.validation.constraints.NotNull;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import org.fuin.esc.api.CommonEvent;
import org.fuin.esc.api.Converter;
import org.fuin.esc.api.EnhancedMimeType;
import org.fuin.esc.api.IBase64Data;
import org.fuin.esc.api.IBaseTypeFactory;
import org.fuin.esc.api.IEscMeta;
import org.fuin.esc.api.SerializedDataType;
import org.fuin.esc.api.Serializer;
import org.fuin.esc.api.SerializerRegistry;
import org.fuin.esc.spi.EscSpiUtils;
import org.fuin.objects4j.common.Contract;

public final class CommonEvent2EventDataConverter
implements Converter<CommonEvent, EventData> {
    private static final EnhancedMimeType XML_UTF8 = EnhancedMimeType.create((String)"application", (String)"xml", (Charset)StandardCharsets.UTF_8);
    private static final EnhancedMimeType JSON_UTF8 = EnhancedMimeType.create((String)"application", (String)"json", (Charset)StandardCharsets.UTF_8);
    private final SerializerRegistry serRegistry;
    private final IBaseTypeFactory baseTypeFactory;
    private final EnhancedMimeType targetContentType;

    public CommonEvent2EventDataConverter(@NotNull SerializerRegistry serRegistry, @NotNull IBaseTypeFactory baseTypeFactory, EnhancedMimeType targetContentType) {
        Contract.requireArgNotNull((String)"serRegistry", (Object)serRegistry);
        Contract.requireArgNotNull((String)"baseTypeFactory", (Object)baseTypeFactory);
        Contract.requireArgNotNull((String)"targetContentType", (Object)targetContentType);
        if (!targetContentType.matchEncoding(JSON_UTF8) && !targetContentType.matchEncoding(XML_UTF8)) {
            throw new IllegalArgumentException("Only 'application/xml' or 'application/json' with 'utf-8' encoding is allowed, but was: " + String.valueOf(targetContentType));
        }
        this.serRegistry = serRegistry;
        this.baseTypeFactory = baseTypeFactory;
        this.targetContentType = targetContentType;
    }

    public EventData convert(CommonEvent commonEvent) {
        byte[] serData;
        String dataType = commonEvent.getDataType().asBaseType();
        SerializedDataType serUserDataType = new SerializedDataType(dataType);
        Serializer userDataSerializer = this.serRegistry.getSerializer(serUserDataType);
        byte[] serUserData = userDataSerializer.marshal(commonEvent.getData(), serUserDataType);
        if (userDataSerializer.getMimeType().matchEncoding(this.targetContentType)) {
            serData = serUserData;
        } else {
            IBase64Data base64data = this.baseTypeFactory.createBase64Data(serUserData);
            Serializer base64Serializer = this.serRegistry.getSerializer(IBase64Data.SER_TYPE);
            serData = base64Serializer.marshal((Object)base64data, IBase64Data.SER_TYPE);
        }
        IEscMeta escMeta = EscSpiUtils.createEscMeta((SerializerRegistry)this.serRegistry, (IBaseTypeFactory)this.baseTypeFactory, (EnhancedMimeType)this.targetContentType, (CommonEvent)commonEvent);
        SerializedDataType escMetaType = new SerializedDataType(IEscMeta.TYPE.asBaseType());
        Serializer escMetaSerializer = this.getSerializer(escMetaType);
        byte[] escSerMeta = escMetaSerializer.marshal((Object)escMeta, escMetaType);
        if (this.targetContentType.isJson()) {
            return EventDataBuilder.json((UUID)commonEvent.getId().asBaseType(), (String)dataType, (byte[])serData).metadataAsBytes(escSerMeta).build();
        }
        return EventDataBuilder.binary((UUID)commonEvent.getId().asBaseType(), (String)dataType, (byte[])serData).metadataAsBytes(escSerMeta).build();
    }

    private Serializer getSerializer(SerializedDataType serDataType) {
        Serializer serializer = this.serRegistry.getSerializer(serDataType);
        if (!serializer.getMimeType().matchEncoding(this.targetContentType)) {
            throw new IllegalArgumentException("Target content type is '" + String.valueOf(this.targetContentType) + "', but serializer returned for " + String.valueOf(serDataType) + "' was: " + String.valueOf(serializer.getMimeType()));
        }
        return serializer;
    }

    public Class<CommonEvent> getSourceType() {
        return CommonEvent.class;
    }

    public Class<EventData> getTargetType() {
        return EventData.class;
    }
}

