/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.esc.esgrpc;

import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.kurrent.dbclient.AppendToStreamOptions;
import io.kurrent.dbclient.DeleteStreamOptions;
import io.kurrent.dbclient.EventData;
import io.kurrent.dbclient.KurrentDBClient;
import io.kurrent.dbclient.ReadResult;
import io.kurrent.dbclient.ReadStreamOptions;
import io.kurrent.dbclient.ResolvedEvent;
import io.kurrent.dbclient.StreamDeletedException;
import io.kurrent.dbclient.WriteResult;
import jakarta.annotation.Nullable;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.fuin.esc.api.CommonEvent;
import org.fuin.esc.api.DeserializerRegistry;
import org.fuin.esc.api.EnhancedMimeType;
import org.fuin.esc.api.EventNotFoundException;
import org.fuin.esc.api.ExpectedVersion;
import org.fuin.esc.api.IBaseTypeFactory;
import org.fuin.esc.api.SerDeserializerRegistry;
import org.fuin.esc.api.SerializerRegistry;
import org.fuin.esc.api.StreamAlreadyExistsException;
import org.fuin.esc.api.StreamEventsSlice;
import org.fuin.esc.api.StreamId;
import org.fuin.esc.api.StreamNotFoundException;
import org.fuin.esc.api.StreamReadOnlyException;
import org.fuin.esc.api.StreamState;
import org.fuin.esc.api.TenantId;
import org.fuin.esc.api.WrongExpectedVersionException;
import org.fuin.esc.esgrpc.CommonEvent2EventDataConverter;
import org.fuin.esc.esgrpc.IESGrpcEventStore;
import org.fuin.esc.esgrpc.RecordedEvent2CommonEventConverter;
import org.fuin.esc.spi.AbstractReadableEventStore;
import org.fuin.esc.spi.EscSpiUtils;
import org.fuin.esc.spi.TenantStreamId;
import org.fuin.objects4j.common.Contract;
import org.fuin.utils4j.TestOmitted;

@TestOmitted(value="Tested in the 'test' project")
public final class ESGrpcEventStore
extends AbstractReadableEventStore
implements IESGrpcEventStore {
    private final KurrentDBClient es;
    private final CommonEvent2EventDataConverter ce2edConv;
    private final RecordedEvent2CommonEventConverter ed2ceConv;
    private final TenantId tenantId;

    private ESGrpcEventStore(@NotNull KurrentDBClient es, @NotNull SerializerRegistry serRegistry, @NotNull DeserializerRegistry desRegistry, @NotNull IBaseTypeFactory baseTypeFactory, @NotNull EnhancedMimeType targetContentType, @Nullable TenantId tenantId) {
        Contract.requireArgNotNull((String)"es", (Object)es);
        Contract.requireArgNotNull((String)"serRegistry", (Object)serRegistry);
        Contract.requireArgNotNull((String)"desRegistry", (Object)desRegistry);
        Contract.requireArgNotNull((String)"baseTypeFactory", (Object)baseTypeFactory);
        Contract.requireArgNotNull((String)"targetContentType", (Object)targetContentType);
        this.es = es;
        this.ce2edConv = new CommonEvent2EventDataConverter(serRegistry, baseTypeFactory, targetContentType);
        this.ed2ceConv = new RecordedEvent2CommonEventConverter(desRegistry);
        this.tenantId = tenantId;
    }

    public ESGrpcEventStore open() {
        return this;
    }

    public void close() {
    }

    public boolean isSupportsCreateStream() {
        return false;
    }

    public void createStream(StreamId streamId) throws StreamAlreadyExistsException {
    }

    public long appendToStream(StreamId streamId, CommonEvent ... events) throws StreamNotFoundException, org.fuin.esc.api.StreamDeletedException, StreamReadOnlyException {
        return this.appendToStream(streamId, -2L, EscSpiUtils.asList((Object[])events));
    }

    public long appendToStream(StreamId streamId, long expectedVersion, CommonEvent ... events) throws StreamNotFoundException, org.fuin.esc.api.StreamDeletedException, WrongExpectedVersionException, StreamReadOnlyException {
        return this.appendToStream(streamId, expectedVersion, EscSpiUtils.asList((Object[])events));
    }

    public long appendToStream(StreamId streamId, List<CommonEvent> events) throws StreamNotFoundException, org.fuin.esc.api.StreamDeletedException, StreamReadOnlyException {
        return this.appendToStream(streamId, -2L, events);
    }

    public long appendToStream(StreamId streamId, long expectedVersion, List<CommonEvent> commonEvents) throws org.fuin.esc.api.StreamDeletedException, WrongExpectedVersionException, StreamReadOnlyException {
        Contract.requireArgNotNull((String)"streamId", (Object)streamId);
        Contract.requireArgMin((String)"expectedVersion", (long)expectedVersion, (long)ExpectedVersion.ANY.getNo());
        Contract.requireArgNotNull((String)"commonEvents", commonEvents);
        this.ensureOpen();
        TenantStreamId sid = new TenantStreamId(this.tenantId, streamId);
        if (sid.isProjection()) {
            throw new StreamReadOnlyException((StreamId)sid);
        }
        try {
            Iterator<EventData> eventDataIt = this.asEventData(commonEvents).iterator();
            WriteResult result = (WriteResult)this.es.appendToStream(sid.asString(), (AppendToStreamOptions)AppendToStreamOptions.get().streamState(ESGrpcEventStore.version2State(expectedVersion)), eventDataIt).get();
            return result.getNextExpectedRevision().toRawLong();
        }
        catch (ExecutionException ex) {
            Throwable throwable = ex.getCause();
            if (throwable instanceof io.kurrent.dbclient.WrongExpectedVersionException) {
                io.kurrent.dbclient.WrongExpectedVersionException cause = (io.kurrent.dbclient.WrongExpectedVersionException)throwable;
                throw new WrongExpectedVersionException((StreamId)sid, Long.valueOf(expectedVersion), Long.valueOf(cause.getActualState().toRawLong()));
            }
            if (ESGrpcEventStore.statusIsDeleted(ex)) {
                throw new org.fuin.esc.api.StreamDeletedException((StreamId)sid);
            }
            if (ex.getCause() instanceof io.kurrent.dbclient.StreamNotFoundException) {
                throw new StreamNotFoundException((StreamId)sid);
            }
            throw new RuntimeException("Error executing appendToStream(..)", ex);
        }
        catch (InterruptedException ex) {
            throw new RuntimeException("Error waiting for appendToStream(..) result", ex);
        }
    }

    public void deleteStream(StreamId streamId, long expectedVersion, boolean hardDelete) throws org.fuin.esc.api.StreamDeletedException, WrongExpectedVersionException {
        Contract.requireArgNotNull((String)"streamId", (Object)streamId);
        Contract.requireArgMin((String)"expectedVersion", (long)expectedVersion, (long)ExpectedVersion.ANY.getNo());
        this.ensureOpen();
        TenantStreamId sid = new TenantStreamId(this.tenantId, streamId);
        if (sid.isProjection()) {
            throw new StreamReadOnlyException((StreamId)sid);
        }
        try {
            DeleteStreamOptions options = (DeleteStreamOptions)DeleteStreamOptions.get().streamState(ESGrpcEventStore.version2State(expectedVersion));
            if (hardDelete) {
                this.es.tombstoneStream(sid.asString(), options).get();
            } else {
                this.es.deleteStream(sid.asString(), options).get();
            }
        }
        catch (ExecutionException ex) {
            Throwable throwable = ex.getCause();
            if (throwable instanceof io.kurrent.dbclient.WrongExpectedVersionException) {
                io.kurrent.dbclient.WrongExpectedVersionException cause = (io.kurrent.dbclient.WrongExpectedVersionException)throwable;
                throw new WrongExpectedVersionException((StreamId)sid, Long.valueOf(expectedVersion), Long.valueOf(cause.getActualState().toRawLong()));
            }
            if (ESGrpcEventStore.statusIsDeleted(ex)) {
                throw new org.fuin.esc.api.StreamDeletedException((StreamId)sid);
            }
            if (ex.getCause() instanceof io.kurrent.dbclient.StreamNotFoundException) {
                throw new StreamNotFoundException((StreamId)sid);
            }
            throw new RuntimeException("Error executing deleteStream(..)", ex);
        }
        catch (InterruptedException ex) {
            throw new RuntimeException("Error waiting for deleteStream(..) result", ex);
        }
    }

    public void deleteStream(StreamId streamId, boolean hardDelete) throws StreamNotFoundException, org.fuin.esc.api.StreamDeletedException {
        this.deleteStream(streamId, ExpectedVersion.ANY.getNo(), hardDelete);
    }

    public StreamEventsSlice readEventsForward(StreamId streamId, long start, int count) {
        Contract.requireArgNotNull((String)"streamId", (Object)streamId);
        Contract.requireArgMin((String)"start", (long)start, (long)0L);
        Contract.requireArgMin((String)"count", (long)count, (long)1L);
        this.ensureOpen();
        TenantStreamId sid = new TenantStreamId(this.tenantId, streamId);
        try {
            ReadStreamOptions options = (ReadStreamOptions)((ReadStreamOptions)ReadStreamOptions.get().forwards().fromRevision(start)).maxCount((long)count).resolveLinkTos();
            ReadResult readResult = (ReadResult)this.es.readStream(sid.asString(), options).get();
            List<CommonEvent> events = this.asCommonEvents(readResult.getEvents());
            boolean endOfStream = count > events.size();
            return new StreamEventsSlice(start, events, start + (long)events.size(), endOfStream);
        }
        catch (ExecutionException ex) {
            if (ESGrpcEventStore.statusIsDeleted(ex)) {
                throw new org.fuin.esc.api.StreamDeletedException((StreamId)sid);
            }
            if (ex.getCause() instanceof io.kurrent.dbclient.StreamNotFoundException) {
                throw new StreamNotFoundException((StreamId)sid);
            }
            throw new RuntimeException("Error executing readEventsForward(..)", ex);
        }
        catch (InterruptedException ex) {
            throw new RuntimeException("Error waiting for readEventsForward(..) result", ex);
        }
    }

    public StreamEventsSlice readEventsBackward(StreamId streamId, long start, int count) {
        Contract.requireArgNotNull((String)"streamId", (Object)streamId);
        Contract.requireArgMin((String)"start", (long)start, (long)0L);
        Contract.requireArgMin((String)"count", (long)count, (long)1L);
        this.ensureOpen();
        TenantStreamId sid = new TenantStreamId(this.tenantId, streamId);
        try {
            boolean endOfStream;
            ReadStreamOptions options = (ReadStreamOptions)((ReadStreamOptions)ReadStreamOptions.get().backwards().fromRevision(start)).maxCount((long)count).resolveLinkTos();
            ReadResult slice = (ReadResult)this.es.readStream(sid.asString(), options).get();
            List<CommonEvent> events = this.asCommonEvents(slice.getEvents());
            long nextEventNumber = start - (long)events.size();
            boolean bl = endOfStream = start - (long)count < 0L;
            if (endOfStream) {
                nextEventNumber = 0L;
            }
            return new StreamEventsSlice(start, events, nextEventNumber, endOfStream);
        }
        catch (ExecutionException ex) {
            if (ESGrpcEventStore.statusIsDeleted(ex)) {
                throw new org.fuin.esc.api.StreamDeletedException((StreamId)sid);
            }
            if (ex.getCause() instanceof io.kurrent.dbclient.StreamNotFoundException) {
                throw new StreamNotFoundException((StreamId)sid);
            }
            throw new RuntimeException("Error executing readEventsBackward(..)", ex);
        }
        catch (InterruptedException ex) {
            throw new RuntimeException("Error waiting for readEventsBackward(..) result", ex);
        }
    }

    public CommonEvent readEvent(StreamId streamId, long eventNumber) {
        StreamEventsSlice slice = this.readEventsForward(streamId, eventNumber, 1);
        if (slice.getEvents().isEmpty()) {
            throw new EventNotFoundException(streamId, eventNumber);
        }
        return (CommonEvent)slice.getEvents().get(0);
    }

    public boolean streamExists(StreamId streamId) {
        Contract.requireArgNotNull((String)"streamId", (Object)streamId);
        this.ensureOpen();
        TenantStreamId sid = new TenantStreamId(this.tenantId, streamId);
        try {
            ReadStreamOptions options = ((ReadStreamOptions)ReadStreamOptions.get().forwards().fromRevision(0L)).maxCount(1L);
            this.es.readStream(sid.asString(), options).get();
            return true;
        }
        catch (ExecutionException ex) {
            if (ex.getCause() instanceof StatusRuntimeException) {
                return false;
            }
            if (ex.getCause() instanceof io.kurrent.dbclient.StreamNotFoundException) {
                return false;
            }
            throw new RuntimeException("Error executing streamExists(..)", ex);
        }
        catch (InterruptedException ex) {
            throw new RuntimeException("Error waiting for streamExists(..) result", ex);
        }
    }

    public StreamState streamState(StreamId streamId) {
        Contract.requireArgNotNull((String)"streamId", (Object)streamId);
        this.ensureOpen();
        TenantStreamId sid = new TenantStreamId(this.tenantId, streamId);
        try {
            this.es.readStream(sid.asString(), (ReadStreamOptions)ReadStreamOptions.get().forwards().fromRevision(0L)).get();
            return StreamState.ACTIVE;
        }
        catch (ExecutionException ex) {
            if (ESGrpcEventStore.statusIsDeleted(ex)) {
                return StreamState.HARD_DELETED;
            }
            if (ex.getCause() instanceof io.kurrent.dbclient.StreamNotFoundException) {
                return this.softDeleted(streamId);
            }
            throw new RuntimeException("Error executing streamState(..)", ex);
        }
        catch (InterruptedException ex) {
            throw new RuntimeException("Error waiting for streamState(..) result", ex);
        }
    }

    private StreamState softDeleted(StreamId streamId) {
        try {
            this.es.readStream("$$" + streamId.asString(), (ReadStreamOptions)ReadStreamOptions.get().forwards().fromRevision(0L)).get();
            throw new StreamNotFoundException(streamId);
        }
        catch (ExecutionException ex) {
            if (ex.getCause() instanceof io.kurrent.dbclient.StreamNotFoundException) {
                throw new StreamNotFoundException(streamId);
            }
            throw new RuntimeException("Error reading stream meta data", ex);
        }
        catch (InterruptedException ex) {
            throw new RuntimeException("Error reading stream status", ex);
        }
    }

    private List<EventData> asEventData(List<CommonEvent> commonEvents) {
        ArrayList<EventData> list = new ArrayList<EventData>(commonEvents.size());
        for (CommonEvent commonEvent : commonEvents) {
            list.add(this.ce2edConv.convert(commonEvent));
        }
        return list;
    }

    private List<CommonEvent> asCommonEvents(List<ResolvedEvent> resolvedEvents) {
        ArrayList<CommonEvent> list = new ArrayList<CommonEvent>(resolvedEvents.size());
        for (ResolvedEvent resolvedEvent : resolvedEvents) {
            list.add(this.asCommonEvent(resolvedEvent));
        }
        return list;
    }

    private CommonEvent asCommonEvent(ResolvedEvent resolvedEvent) {
        return this.ed2ceConv.convert(resolvedEvent.getEvent());
    }

    private void ensureOpen() {
        if (this.es.isShutdown()) {
            throw new IllegalStateException("The event store has already been closed");
        }
    }

    private static boolean statusIsDeleted(ExecutionException ex) {
        Throwable throwable = ex.getCause();
        if (throwable instanceof StatusRuntimeException) {
            StatusRuntimeException sre = (StatusRuntimeException)throwable;
            return sre.getStatus().getCode().equals((Object)Status.FAILED_PRECONDITION.getCode()) && sre.getStatus().getDescription() != null && sre.getStatus().getDescription().contains("is deleted");
        }
        return ex.getCause() instanceof StreamDeletedException;
    }

    private static io.kurrent.dbclient.StreamState version2State(long version) {
        if (version == ExpectedVersion.ANY.getNo()) {
            return io.kurrent.dbclient.StreamState.any();
        }
        if (version == ExpectedVersion.NO_OR_EMPTY_STREAM.getNo()) {
            return io.kurrent.dbclient.StreamState.noStream();
        }
        return io.kurrent.dbclient.StreamState.streamRevision((long)version);
    }

    public static final class Builder {
        private KurrentDBClient eventStore;
        private SerializerRegistry serRegistry;
        private DeserializerRegistry desRegistry;
        private IBaseTypeFactory baseTypeFactory;
        private EnhancedMimeType targetContentType;
        private TenantId tenantId;

        public Builder eventStore(KurrentDBClient eventStore) {
            this.eventStore = eventStore;
            return this;
        }

        public Builder serRegistry(SerializerRegistry serRegistry) {
            this.serRegistry = serRegistry;
            return this;
        }

        public Builder desRegistry(DeserializerRegistry desRegistry) {
            this.desRegistry = desRegistry;
            return this;
        }

        public Builder serDesRegistry(SerDeserializerRegistry registry) {
            this.serRegistry = registry;
            this.desRegistry = registry;
            return this;
        }

        public Builder baseTypeFactory(IBaseTypeFactory baseTypeFactory) {
            this.baseTypeFactory = baseTypeFactory;
            return this;
        }

        public Builder targetContentType(EnhancedMimeType targetContentType) {
            this.targetContentType = targetContentType;
            return this;
        }

        public Builder tenantId(TenantId tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        private void verifyNotNull(String name, Object value) {
            if (value == null) {
                throw new IllegalStateException("It is mandatory to set the value of '" + name + "' before calling the 'build()' method");
            }
        }

        public ESGrpcEventStore build() {
            this.verifyNotNull("eventStore", this.eventStore);
            this.verifyNotNull("serRegistry", this.serRegistry);
            this.verifyNotNull("desRegistry", this.desRegistry);
            this.verifyNotNull("baseTypeFactory", this.baseTypeFactory);
            this.verifyNotNull("targetContentType", this.targetContentType);
            return new ESGrpcEventStore(this.eventStore, this.serRegistry, this.desRegistry, this.baseTypeFactory, this.targetContentType, this.tenantId);
        }
    }
}

