/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.esc.esgrpc;

import io.kurrent.dbclient.RecordedEvent;
import jakarta.validation.constraints.NotNull;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.fuin.esc.api.CommonEvent;
import org.fuin.esc.api.Converter;
import org.fuin.esc.api.Deserializer;
import org.fuin.esc.api.DeserializerRegistry;
import org.fuin.esc.api.EnhancedMimeType;
import org.fuin.esc.api.EventId;
import org.fuin.esc.api.IBase64Data;
import org.fuin.esc.api.IEscMeta;
import org.fuin.esc.api.SerializedDataType;
import org.fuin.esc.api.SimpleCommonEvent;
import org.fuin.esc.api.TypeName;
import org.fuin.objects4j.common.Contract;

public final class RecordedEvent2CommonEventConverter
implements Converter<RecordedEvent, CommonEvent> {
    private final DeserializerRegistry deserRegistry;

    public RecordedEvent2CommonEventConverter(@NotNull DeserializerRegistry deserRegistry) {
        Contract.requireArgNotNull((String)"deserRegistry", (Object)deserRegistry);
        this.deserRegistry = deserRegistry;
    }

    public CommonEvent convert(RecordedEvent eventData) {
        EnhancedMimeType escMetaMimeType = this.metaMimeType(eventData.getContentType().equals("application/json"));
        SerializedDataType escSerMetaType = new SerializedDataType(IEscMeta.TYPE.asBaseType());
        Deserializer escMetaDeserializer = this.deserRegistry.getDeserializer(escSerMetaType, escMetaMimeType);
        IEscMeta escMeta = (IEscMeta)escMetaDeserializer.unmarshal((Object)eventData.getUserMetadata(), escSerMetaType, escMetaMimeType);
        EnhancedMimeType metaMimeType = escMeta.getMetaContentType();
        String metaTransferEncoding = escMeta.getMetaType() == null || escMeta.getMetaContentType() == null ? null : escMeta.getMetaContentType().getParameter("transfer-encoding");
        EnhancedMimeType dataMimeType = escMeta.getDataContentType();
        SerializedDataType serDataType = new SerializedDataType(escMeta.getDataType());
        Deserializer dataDeserializer = this.deserRegistry.getDeserializer(serDataType, dataMimeType);
        String dataTransferEncoding = escMeta.getDataContentType().getParameter("transfer-encoding");
        Object data = this.unmarshal(dataTransferEncoding, serDataType, dataDeserializer, dataMimeType, eventData.getEventData(), metaMimeType, escMetaMimeType);
        EventId eventId = new EventId(eventData.getEventId());
        TypeName dataType = new TypeName(eventData.getEventType());
        if (escMeta.getMetaType() == null) {
            return new SimpleCommonEvent(eventId, dataType, data);
        }
        TypeName metaType = new TypeName(escMeta.getMetaType());
        SerializedDataType serMetaType = new SerializedDataType(escMeta.getMetaType());
        Deserializer metaDeserializer = this.deserRegistry.getDeserializer(serMetaType, metaMimeType);
        Object meta = this.unmarshal(metaTransferEncoding, serMetaType, metaDeserializer, metaMimeType, escMeta.getMeta(), metaMimeType, escMetaMimeType);
        return new SimpleCommonEvent(eventId, dataType, data, metaType, meta);
    }

    private Object unmarshal(String transferEncoding, SerializedDataType dataType, Deserializer dataDeserializer, EnhancedMimeType dataMimeType, Object data, EnhancedMimeType metaMimeType, EnhancedMimeType escMetaMimeType) {
        if (transferEncoding == null) {
            return dataDeserializer.unmarshal(data, dataType, dataMimeType);
        }
        if (data instanceof IBase64Data) {
            IBase64Data base64Data = (IBase64Data)data;
            return dataDeserializer.unmarshal((Object)base64Data.getDecoded(), dataType, dataMimeType);
        }
        Deserializer base64Deserializer = this.deserRegistry.getDeserializer(IBase64Data.SER_TYPE, escMetaMimeType);
        IBase64Data base64Data = (IBase64Data)base64Deserializer.unmarshal(data, IBase64Data.SER_TYPE, escMetaMimeType);
        return dataDeserializer.unmarshal((Object)base64Data.getDecoded(), dataType, dataMimeType);
    }

    private EnhancedMimeType metaMimeType(boolean json) {
        if (json) {
            return EnhancedMimeType.create((String)"application", (String)"json", (Charset)StandardCharsets.UTF_8);
        }
        return EnhancedMimeType.create((String)"application", (String)"xml", (Charset)StandardCharsets.UTF_8);
    }

    public Class<RecordedEvent> getSourceType() {
        return RecordedEvent.class;
    }

    public Class<CommonEvent> getTargetType() {
        return CommonEvent.class;
    }
}

