/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.esc.esgrpc.example;

import io.kurrent.dbclient.DeleteResult;
import io.kurrent.dbclient.DeleteStreamOptions;
import io.kurrent.dbclient.EventData;
import io.kurrent.dbclient.KurrentDBClient;
import io.kurrent.dbclient.KurrentDBClientSettings;
import io.kurrent.dbclient.KurrentDBConnectionString;
import io.kurrent.dbclient.ReadResult;
import io.kurrent.dbclient.ReadStreamOptions;
import io.kurrent.dbclient.ResolvedEvent;
import io.kurrent.dbclient.WriteResult;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ExecutionException;
import org.fuin.utils4j.TestOmitted;

@TestOmitted(value="Example class")
public class App {
    private App() {
    }

    public static void main(String[] args) throws InterruptedException, ExecutionException, IOException {
        System.out.println("BEGIN");
        KurrentDBClientSettings setts = KurrentDBConnectionString.parseOrThrow((String)"esdb://localhost:2113?tls=false");
        KurrentDBClient client = KurrentDBClient.create((KurrentDBClientSettings)setts);
        String json = "{\n    \"id\" : \"3b92d23e-837a-441e-b59e-1733182f741c\",\n    \"login\" : \"ouros\"\n}\n";
        EventData event = EventData.builderAsJson((String)"account-created", (byte[])json.getBytes(StandardCharsets.UTF_8)).build();
        String streamName = "accounts3";
        WriteResult writeResult = (WriteResult)client.appendToStream(streamName, new EventData[]{event}).get();
        System.out.println("writeResult=" + String.valueOf(writeResult));
        ReadStreamOptions readStreamOptions = (ReadStreamOptions)((ReadStreamOptions)ReadStreamOptions.get().fromStart()).maxCount(1L).notResolveLinkTos();
        ReadResult readResult = (ReadResult)client.readStream(streamName, readStreamOptions).get();
        System.out.println("readResult=" + String.valueOf(readResult));
        ResolvedEvent resolvedEvent = (ResolvedEvent)readResult.getEvents().get(0);
        System.out.println("resolvedEvent=" + String.valueOf(resolvedEvent));
        String writtenEvent = new String(resolvedEvent.getOriginalEvent().getEventData(), StandardCharsets.UTF_8);
        System.out.println("writtenEvent=" + writtenEvent);
        DeleteResult deleteResult = (DeleteResult)client.tombstoneStream(streamName, DeleteStreamOptions.get()).get();
        System.out.println("deleteResult=" + String.valueOf(deleteResult));
        System.out.println("END");
    }
}

