/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.esc.jackson;

import jakarta.validation.constraints.NotNull;
import java.util.Base64;
import org.fuin.esc.api.HasSerializedDataTypeConstant;
import org.fuin.esc.api.IBase64Data;
import org.fuin.objects4j.common.Contract;

@HasSerializedDataTypeConstant
public final class Base64Data
implements IBase64Data {
    private String base64Str;
    private byte[] binaryData;

    protected Base64Data() {
    }

    public Base64Data(@NotNull String base64Str) {
        Contract.requireArgNotNull((String)"base64Str", (Object)base64Str);
        this.base64Str = base64Str;
        this.binaryData = Base64.getDecoder().decode(base64Str);
    }

    public Base64Data(@NotNull byte[] binaryData) {
        Contract.requireArgNotNull((String)"binaryData", (Object)binaryData);
        this.base64Str = Base64.getEncoder().encodeToString(binaryData);
        this.binaryData = binaryData;
    }

    public String getEncoded() {
        return this.base64Str;
    }

    public byte[] getDecoded() {
        if (this.binaryData == null) {
            this.binaryData = Base64.getDecoder().decode(this.base64Str);
        }
        return this.binaryData;
    }
}

