/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.esc.jackson;

import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import javax.annotation.concurrent.Immutable;
import org.fuin.esc.api.EnhancedMimeType;
import org.fuin.esc.api.IData;
import org.fuin.objects4j.common.Contract;
import org.fuin.objects4j.common.ValueObject;

@Immutable
public final class Data
implements IData,
ValueObject,
Serializable {
    private static final long serialVersionUID = 1000L;
    @NotNull
    private String type;
    @NotNull
    private String mimeType;
    @NotNull
    private String content;

    protected Data() {
    }

    public Data(@NotNull String type, @NotNull EnhancedMimeType mimeType, @NotNull String content) {
        Contract.requireArgNotNull((String)"type", (Object)type);
        Contract.requireArgNotNull((String)"mimeType", (Object)mimeType);
        Contract.requireArgNotNull((String)"content", (Object)content);
        this.type = type;
        this.mimeType = mimeType.toString();
        this.content = content;
    }

    @NotNull
    public String getType() {
        return this.type;
    }

    @NotNull
    public EnhancedMimeType getMimeType() {
        return EnhancedMimeType.create((String)this.mimeType);
    }

    @NotNull
    public String getContent() {
        return this.content;
    }

    public String toString() {
        return "Data{type='" + this.type + "', mimeType='" + this.mimeType + "', content='" + this.content + "'}";
    }
}

