/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.esc.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.util.Objects;
import org.fuin.esc.api.DeserializerRegistry;
import org.fuin.esc.api.EnhancedMimeType;
import org.fuin.esc.api.SerializedDataType;
import org.fuin.esc.jackson.Base64Data;
import org.fuin.esc.jackson.DataWrapper;
import org.fuin.esc.jackson.EscEvent;
import org.fuin.esc.jackson.EscJacksonUtils;
import org.fuin.esc.jackson.EscMeta;
import org.fuin.objects4j.jackson.Objects4JacksonUtils;
import org.fuin.utils4j.TestOmitted;

@TestOmitted(value="Already tested along with the other tests in this package")
public final class EscEventJacksonDeserializer
extends StdDeserializer<EscEvent> {
    private final DeserializerRegistry deserializerRegistry;

    public EscEventJacksonDeserializer(DeserializerRegistry deserializerRegistry) {
        super(EscEvent.class);
        this.deserializerRegistry = Objects.requireNonNull(deserializerRegistry, "deserializerRegistry==null");
    }

    public EscEvent deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        EscEvent escEvent = new EscEvent();
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        escEvent.setEventId(node.get("EventId").asText());
        escEvent.setEventType(node.get("EventType").asText());
        JsonNode metaNode = node.get("MetaData");
        EscMeta escMeta = (EscMeta)Objects4JacksonUtils.deserialize((JsonParser)jp, (DeserializationContext)ctxt, EscMeta.class, (JsonNode)metaNode);
        escEvent.setMeta(new DataWrapper(escMeta));
        JsonNode dataNode = node.get("Data");
        JsonNode base64Node = dataNode.get("Base64");
        if (base64Node == null) {
            SerializedDataType dataType = new SerializedDataType(escEvent.getEventType());
            EnhancedMimeType dataContentType = escMeta.getDataContentType();
            Object data = EscJacksonUtils.deserialize(dataNode, dataType, dataContentType, this.deserializerRegistry);
            escEvent.setData(new DataWrapper(data));
        } else {
            escEvent.setData(new DataWrapper(new Base64Data(base64Node.asText())));
        }
        return escEvent;
    }
}

