/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.esc.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.Objects;
import org.fuin.esc.api.SerializedDataType;
import org.fuin.esc.api.SerializerRegistry;
import org.fuin.esc.jackson.Base64Data;
import org.fuin.esc.jackson.EscEvent;
import org.fuin.esc.jackson.EscJacksonUtils;
import org.fuin.utils4j.TestOmitted;

@TestOmitted(value="Already tested along with the other tests in this package")
public final class EscEventJacksonSerializer
extends StdSerializer<EscEvent> {
    private final SerializerRegistry serializerRegistry;

    public EscEventJacksonSerializer(SerializerRegistry serializerRegistry) {
        super(EscEvent.class);
        this.serializerRegistry = Objects.requireNonNull(serializerRegistry, "serializerRegistry==null");
    }

    public void serialize(EscEvent escEvent, JsonGenerator generator, SerializerProvider provider) throws IOException {
        generator.writeStartObject();
        if (escEvent != null) {
            generator.writeStringField("EventId", escEvent.getEventId());
            generator.writeStringField("EventType", escEvent.getEventType());
            Object object = escEvent.getData().getObj();
            if (object instanceof Base64Data) {
                Base64Data base64Data = (Base64Data)object;
                generator.writeObjectField("Data", (Object)base64Data);
            } else {
                SerializedDataType serDataType = new SerializedDataType(escEvent.getEventType());
                EscJacksonUtils.serialize(generator, this.serializerRegistry, serDataType, "Data", escEvent.getData().getObj());
            }
            provider.defaultSerializeField("MetaData", escEvent.getMeta().getObj(), generator);
        }
        generator.writeEndObject();
    }
}

