/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.esc.jackson;

import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.deser.Deserializers;
import com.fasterxml.jackson.databind.module.SimpleDeserializers;
import com.fasterxml.jackson.databind.module.SimpleSerializers;
import com.fasterxml.jackson.databind.ser.Serializers;
import java.util.Objects;
import org.fuin.esc.api.DeserializerRegistry;
import org.fuin.esc.api.EventId;
import org.fuin.esc.api.SerializerRegistry;
import org.fuin.esc.api.TypeName;
import org.fuin.esc.jackson.Base64Data;
import org.fuin.esc.jackson.Base64DataJacksonDeserializer;
import org.fuin.esc.jackson.Base64DataJacksonSerializer;
import org.fuin.esc.jackson.EscEvent;
import org.fuin.esc.jackson.EscEventJacksonDeserializer;
import org.fuin.esc.jackson.EscEventJacksonSerializer;
import org.fuin.esc.jackson.EscEvents;
import org.fuin.esc.jackson.EscEventsJacksonDeserializer;
import org.fuin.esc.jackson.EscEventsJacksonSerializer;
import org.fuin.esc.jackson.EscMeta;
import org.fuin.esc.jackson.EscMetaJacksonDeserializer;
import org.fuin.esc.jackson.EscMetaJacksonSerializer;
import org.fuin.objects4j.jackson.ValueObjectStringJacksonDeserializer;
import org.fuin.objects4j.jackson.ValueObjectStringJacksonSerializer;
import org.fuin.utils4j.TestOmitted;

@TestOmitted(value="Trivial")
public class EscJacksonModule
extends Module {
    private final DeserializerRegistry deserializerRegistry;
    private final SerializerRegistry serializerRegistry;

    public EscJacksonModule(DeserializerRegistry deserializerRegistry, SerializerRegistry serializerRegistry) {
        this.deserializerRegistry = Objects.requireNonNull(deserializerRegistry, "deserializerRegistry==null");
        this.serializerRegistry = Objects.requireNonNull(serializerRegistry, "serializerRegistry==null");
    }

    public String getModuleName() {
        return "Objects4JModule";
    }

    public void setupModule(Module.SetupContext context) {
        SimpleSerializers serializers = new SimpleSerializers();
        serializers.addSerializer(Base64Data.class, (JsonSerializer)new Base64DataJacksonSerializer());
        serializers.addSerializer(EscEvents.class, (JsonSerializer)new EscEventsJacksonSerializer());
        serializers.addSerializer(EscEvent.class, (JsonSerializer)new EscEventJacksonSerializer(this.serializerRegistry));
        serializers.addSerializer(EscMeta.class, (JsonSerializer)new EscMetaJacksonSerializer(this.serializerRegistry));
        serializers.addSerializer(EventId.class, (JsonSerializer)new ValueObjectStringJacksonSerializer(EventId.class));
        serializers.addSerializer(TypeName.class, (JsonSerializer)new ValueObjectStringJacksonSerializer(TypeName.class));
        context.addSerializers((Serializers)serializers);
        SimpleDeserializers deserializers = new SimpleDeserializers();
        deserializers.addDeserializer(Base64Data.class, (JsonDeserializer)new Base64DataJacksonDeserializer());
        deserializers.addDeserializer(EscEvents.class, (JsonDeserializer)new EscEventsJacksonDeserializer());
        deserializers.addDeserializer(EscEvent.class, (JsonDeserializer)new EscEventJacksonDeserializer(this.deserializerRegistry));
        deserializers.addDeserializer(EscMeta.class, (JsonDeserializer)new EscMetaJacksonDeserializer(this.deserializerRegistry));
        deserializers.addDeserializer(EventId.class, (JsonDeserializer)new ValueObjectStringJacksonDeserializer(EventId.class, EventId::valueOf));
        deserializers.addDeserializer(TypeName.class, (JsonDeserializer)new ValueObjectStringJacksonDeserializer(TypeName.class, TypeName::valueOf));
        context.addDeserializers((Deserializers)deserializers);
    }

    public Version version() {
        return new Version(0, 9, 0, "", "org.fuin.esc", "esc-jackson");
    }
}

